package com.atlassian.db.config.password.ciphers.algorithm.paramters;

public class DecryptionParameters {
    private final String sealedObjectFilePath;
    private final String keyFilePath;

    public DecryptionParameters(final String sealedObjectFilePath, final String keyFilePath) {
        this.sealedObjectFilePath = sealedObjectFilePath;
        this.keyFilePath = keyFilePath;
    }

    public String getSealedObjectFilePath() {
        return sealedObjectFilePath;
    }

    public String getKeyFilePath() {
        return keyFilePath;
    }

    public static class Builder {

        private String sealedObjectFilePath;
        private String keyFilePath;

        public Builder setSealedObjectFilePath(final String sealedObjectFilePath) {
            this.sealedObjectFilePath = sealedObjectFilePath;
            return this;
        }

        public Builder setKeyFilePath(final String keyFilePath) {
            this.keyFilePath = keyFilePath;
            return this;
        }

        public DecryptionParameters build() {
            return new DecryptionParameters(sealedObjectFilePath, keyFilePath);
        }
    }

    @Override
    public String toString() {
        return "DecryptionParameters{" +
                "sealedObjectFilePath='" + sealedObjectFilePath + '\'' +
                ", keyFilePath='" + keyFilePath + '\'' +
                '}';
    }
}
