package com.atlassian.dc.filestore.api;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;

/**
 * Represents a snapshot of a {@link FileStore.Path}. The snapshot contains a copy of every file under that path.
 *
 * @since 0.7.0
 */
public interface Snapshot extends Closeable {
    /**
     * Unpacks the snapshot at the given filesstem path.
     */
    void unpack(Path destination) throws IOException;
}

