package com.atlassian.dc.filestore.api;

import com.atlassian.annotations.ExperimentalApi;

import java.util.Objects;

/**
 * A representation of data quantity.
 */
@ExperimentalApi
public final class DataSize implements Comparable<DataSize> {

    public static DataSize ofBytes(final long bytes) {
        return new DataSize(bytes);
    }

    private final long bytes;

    private DataSize(long bytes) {
        this.bytes = bytes;
    }

    public long getBytes() {
        return bytes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        DataSize dataSize = (DataSize) o;
        return bytes == dataSize.bytes;
    }

    @Override
    public int hashCode() {
        return Objects.hash(bytes);
    }

    @Override
    public int compareTo(DataSize other) {
        return Long.compare(this.bytes, other.bytes);
    }

    @Override
    public String toString() {
        return String.format("%dB", bytes);
    }
}
