package com.atlassian.dc.filestore.api.compat;

import com.atlassian.dc.filestore.api.FileStore;

import javax.annotation.CheckReturnValue;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * An extension of {@link FileStore.Path} which provides visibility on the local filesystem's underlying path structure.
 * <p>
 * Use of this interface should be considered a stop-gap measure to provide backward-compatibility with code that
 * requires access to the underlying files.
 */
public interface FilesystemPath extends FileStore.Path, FilesystemAccess {
    /**
     * Deletes the file at the given path, and prunes any empty directories.
     *
     * @return a {@link Pruner}
     * @since 0.6.0
     */
    @CheckReturnValue
    Pruner deleteFileAndPrune() throws IOException;

    @Override
    FilesystemPath path(String... pathComponents);

    @Override
    Stream<FilesystemPath> getFileDescendents() throws IOException;

    /**
     * @return The path representing the parent direvtory of this {@link FilesystemPath}
     * @since 0.8
     */
    Optional<FilesystemPath> getParent();

    /**
     * @since 0.6.0
     */
    interface Pruner {
        /**
         * Prunes empty parent directories until the given directory is reached.
         */
        void untilReach(FilesystemPath directoryPath);
    }
}
