package com.atlassian.dc.filestore.api.compat;

import com.atlassian.dc.filestore.api.FileStore;

import java.nio.file.Path;

/**
 * Provides operation to provide access to the underlying filesystem.
 *
 * @since 0.7.0
 */
public interface FilesystemAccess {
    /**
     * @return The local filesystem {@link Path} representing this {@link FileStore.Path}.
     * @throws AccessDenied if runtime access to the filesystem is not permitted.
     */
    Path asJavaPath();

    /**
     * @return The local filesystem {@link java.io.File} representing this {@link FileStore.Path}.
     * @throws AccessDenied if runtime access to the filesystem is not permitted.
     */
    default java.io.File asJavaFile() {
        return asJavaPath().toFile();
    }

    /**
     * @return The local filesystem {@link Path} representing this {@link FileStore.Path}.
     * @deprecated use {@link #asJavaPath()}
     */
    @Deprecated
    default Path getFilesystemPath() {
        return asJavaPath();
    }

    class AccessDenied extends RuntimeException {
        public AccessDenied(Path path) {
            super("Accedd denied to filesystem path " + path);
        }
    }
}
