package com.atlassian.dc.filestore.api.compat;

import com.atlassian.dc.filestore.api.FileStore;

/**
 * An extension of {@link FileStore.Path} which provides visibility on the local filesystem's underlying path structure.
 * <p>
 * Use of this interface should be considered a stop-gap measure to provide backward-compatibility with code that
 * requires access to the underlying files.
 */
public interface FilesystemPath extends FileStore.Path {
    /**
     * @return The local filesystem {@link java.nio.file.Path} representing this {@link FileStore.Path}.
     * @deprecated use {@link #asJavaPath()}
     */
    @Deprecated
    default java.nio.file.Path getFilesystemPath() {
        return asJavaPath();
    }

    /**
     * @return The local filesystem {@link java.nio.file.Path} representing this {@link FileStore.Path}.
     */
    java.nio.file.Path asJavaPath();

    /**
     * @return The local filesystem {@link java.io.File} representing this {@link FileStore.Path}.
     */
    default java.io.File asJavaFile() {
        return asJavaPath().toFile();
    }

    @Override
    FilesystemPath path(String... pathComponents);
}
