package com.atlassian.data.markov

import com.atlassian.data.ValuesWithFrequencies

class MarkovChainSentenceGenerator(
    valueLinks: MutableMap<Int, ValuesWithFrequencies<Int>>,
    private val id2value: Array<String>
) {
    private val markovChainGenerator = MarkovChainGenerator(valueLinks)

    private val punctuation = mutableSetOf<Int>()

    init {
        for (id in id2value.indices) {
            val token = id2value[id]
            if (token.isEmpty() || Character.isLetterOrDigit(token.codePointAt(0))) {
                continue
            }
            punctuation.add(id)
        }
    }

    private fun wordCounter(list: Collection<Int>) : Int {
        return list.filter { !punctuation.contains(it) }.size
    }

    fun generateSentence(preferredLength: Int=Int.MAX_VALUE): String {
        val idChain = markovChainGenerator.generateChain(5, preferredLength, ::wordCounter)

        val sentenceString = idChain
            .map { id2value[it] }
            .joinToString(" ")
            .replace(" ,", ",")
            .replace(" & ", "&")
            .replace(" / ", "/")
            .replace(" : ", ": ")
            .replace(" ; ", "; ")
        return sentenceString.capitalize()
    }
}
