package com.atlassian.crowd.embedded.core;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.PasswordScore;
import com.atlassian.crowd.embedded.api.PasswordScoreService;

import java.util.Collection;

/**
 * A convenience implementation of password score service that always returns
 * {@link com.atlassian.crowd.embedded.api.PasswordScore#VERY_STRONG}, intended for use by products which do not intend to
 * implement PasswordScoreService in a meaningful way.
 */
public class NoOpPasswordScoreServiceImpl implements PasswordScoreService {
    /**
     * @return {@link com.atlassian.crowd.embedded.api.PasswordScore#VERY_STRONG}, always.
     */
    @Override
    public PasswordScore getPasswordScore(PasswordCredential passwordCredential, Collection<String> userInfo) {
        // a no-op score service will just allow everything through, so set strength to maximum
        return PasswordScore.VERY_STRONG;
    }
}
