package com.atlassian.crowd.embedded.validator.rule;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.validator.ValidationRule;

import java.util.function.Function;

/**
 * Builder utility extending the base class {@link RuleBuilder} specifically for Directory related {@link ValidationRule}
 *
 * @since 3.2.0
 */
public class DirectoryRuleBuilder extends RuleBuilder<Directory> {

    private DirectoryRuleBuilder(String fieldName) {
        super(fieldName);
    }

    /**
     * Constructs a RuleBuilder instance for the given field name
     *
     * @param fieldName Name of the field for which error would be mapped
     * @return {@link DirectoryRuleBuilder} instance for the given field name
     */
    public static DirectoryRuleBuilder ruleFor(String fieldName) {
        return new DirectoryRuleBuilder(fieldName);
    }

    /**
     * Utility method Creates and returns a {@link Function} that will get the string value of the given attribute key from the {@link java.util.Map} of directory attributes
     *
     * @param attributeKey The key tobe retrieved from the directory attributes map
     * @return {@link Function} which will get the attribute key from {@link java.util.Map} of directory attributes
     */
    public static Function<Directory, String> valueOf(String attributeKey) {
        return directory -> directory.getValue(attributeKey);
    }

}
