package com.atlassian.crowd.embedded.validator.impl;

import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.validator.DirectoryValidator;
import com.atlassian.crowd.embedded.validator.ValidationRule;
import com.atlassian.crowd.util.I18nHelper;
import com.google.common.collect.ImmutableList;

import java.util.List;

import static com.atlassian.crowd.embedded.validator.impl.DirectoryValidatorMessages.CROWD_DIRECTORY.INVALID_HTTP_MAX_CONNECTIONS;
import static com.atlassian.crowd.embedded.validator.rule.DirectoryRuleBuilder.ruleFor;
import static com.atlassian.crowd.embedded.validator.rule.DirectoryRuleBuilder.valueOf;
import static com.atlassian.crowd.embedded.validator.rule.RuleBuilder.greaterThanOrEquals;
import static com.atlassian.crowd.embedded.validator.rule.RuleBuilder.isNull;
import static com.atlassian.crowd.embedded.validator.rule.RuleBuilder.message;
import static com.atlassian.crowd.embedded.validator.rule.RuleBuilder.not;

public class RemoteCrowdConnectorValidator extends DirectoryValidator {

    public static final String POLLING_INTERVAL_IN_MIN = "pollingIntervalInMin";
    public static final String CROWD_HTTP_MAX_CONNECTIONS = "httpMaxConnections";


    public RemoteCrowdConnectorValidator(I18nHelper i18nHelper) {
        super(i18nHelper);
    }

    @Override
    protected List<ValidationRule<Directory>> initializeValidators(I18nHelper i18nHelper) {
        final ImmutableList.Builder<ValidationRule<Directory>> ruleListBuilder = ImmutableList.builder();
        ruleListBuilder.add(ruleFor(CROWD_HTTP_MAX_CONNECTIONS)
                .check(valueOf(RemoteCrowdDirectory.CROWD_HTTP_MAX_CONNECTIONS), isNull().or(not(greaterThanOrEquals(0L))))
                .ifMatchesThenSet(message(i18nHelper, INVALID_HTTP_MAX_CONNECTIONS)).build());

        return ruleListBuilder.build();
    }

}
