package com.atlassian.crowd.embedded.validator.impl;

import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.validator.DirectoryValidator;
import com.atlassian.crowd.embedded.validator.ValidationRule;
import com.atlassian.crowd.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

import static com.atlassian.crowd.embedded.validator.rule.DirectoryRuleBuilder.ruleFor;
import static com.atlassian.crowd.embedded.validator.rule.DirectoryRuleBuilder.valueOf;
import static com.atlassian.crowd.embedded.validator.rule.RuleBuilder.message;

public class LDAPGroupSearchConfigValidator extends DirectoryValidator {

    public LDAPGroupSearchConfigValidator(I18nHelper i18nHelper) {
        super(i18nHelper);
    }

    @Override
    protected List<ValidationRule<Directory>> initializeValidators(I18nHelper i18nHelper) {
        final ImmutableList.Builder<ValidationRule<Directory>> ruleListBuilder = ImmutableList.builder();

        ruleListBuilder.add(ruleFor(LDAPGroupConfigValidator.GROUP_OBJECT_FILTER)
                .check(valueOf(LDAPPropertiesMapper.GROUP_OBJECTFILTER_KEY), StringUtils::isBlank)
                .ifMatchesThenSet(message(i18nHelper, DirectoryValidatorMessages.GROUP_CONFIGURATION.INVALID_GROUP_OBJECT_FILTER))
                .build());

        ruleListBuilder.add(ruleFor(LDAPGroupConfigValidator.GROUP_NAME_ATTRIBUTE)
                .check(valueOf(LDAPPropertiesMapper.GROUP_NAME_KEY), StringUtils::isBlank)
                .ifMatchesThenSet(message(i18nHelper, DirectoryValidatorMessages.GROUP_CONFIGURATION.INVALID_GROUP_NAME))
                .build());

        return ruleListBuilder.build();
    }
}
