package com.atlassian.crowd.embedded.validator.impl;

import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.validator.DirectoryValidator;
import com.atlassian.crowd.embedded.validator.ValidationRule;
import com.atlassian.crowd.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

import static com.atlassian.crowd.embedded.validator.impl.DirectoryValidatorMessages.GROUP_CONFIGURATION.INVALID_GROUP_DESCRIPTION;
import static com.atlassian.crowd.embedded.validator.impl.DirectoryValidatorMessages.GROUP_CONFIGURATION.INVALID_GROUP_MEMBER;
import static com.atlassian.crowd.embedded.validator.impl.DirectoryValidatorMessages.GROUP_CONFIGURATION.INVALID_GROUP_NAME;
import static com.atlassian.crowd.embedded.validator.impl.DirectoryValidatorMessages.GROUP_CONFIGURATION.INVALID_GROUP_OBJECT_CLASS;
import static com.atlassian.crowd.embedded.validator.impl.DirectoryValidatorMessages.GROUP_CONFIGURATION.INVALID_GROUP_OBJECT_FILTER;
import static com.atlassian.crowd.embedded.validator.rule.DirectoryRuleBuilder.ruleFor;
import static com.atlassian.crowd.embedded.validator.rule.DirectoryRuleBuilder.valueOf;
import static com.atlassian.crowd.embedded.validator.rule.RuleBuilder.message;

public class LDAPGroupConfigValidator extends DirectoryValidator {

    public static final String GROUP_DESCRIPTION_ATTRIBUTE = "groupDescriptionAttr";
    public static final String GROUP_MEMBER_ATTRIBUTE = "groupMemberAttr";
    public static final String GROUP_NAME_ATTRIBUTE = "groupNameAttr";
    public static final String GROUP_OBJECT_CLASS = "groupObjectClass";
    public static final String GROUP_OBJECT_FILTER = "groupObjectFilter";

    public LDAPGroupConfigValidator(I18nHelper i18nHelper) {
        super(i18nHelper);
    }

    @Override
    protected List<ValidationRule<Directory>> initializeValidators(I18nHelper i18nHelper) {
        final ImmutableList.Builder<ValidationRule<Directory>> ruleListBuilder = ImmutableList.builder();

        ruleListBuilder.add(ruleFor(GROUP_OBJECT_CLASS)
                .check(valueOf(LDAPPropertiesMapper.GROUP_OBJECTCLASS_KEY), StringUtils::isBlank)
                .ifMatchesThenSet(message(i18nHelper, INVALID_GROUP_OBJECT_CLASS))
                .build());

        ruleListBuilder.add(ruleFor(GROUP_OBJECT_FILTER)
                .check(valueOf(LDAPPropertiesMapper.GROUP_OBJECTFILTER_KEY), StringUtils::isBlank)
                .ifMatchesThenSet(message(i18nHelper, INVALID_GROUP_OBJECT_FILTER))
                .build());

        ruleListBuilder.add(ruleFor(GROUP_NAME_ATTRIBUTE)
                .check(valueOf(LDAPPropertiesMapper.GROUP_NAME_KEY), StringUtils::isBlank)
                .ifMatchesThenSet(message(i18nHelper, INVALID_GROUP_NAME))
                .build());

        ruleListBuilder.add(ruleFor(GROUP_DESCRIPTION_ATTRIBUTE)
                .check(valueOf(LDAPPropertiesMapper.GROUP_DESCRIPTION_KEY), StringUtils::isBlank)
                .ifMatchesThenSet(message(i18nHelper, INVALID_GROUP_DESCRIPTION))
                .build());

        ruleListBuilder.add(ruleFor(GROUP_MEMBER_ATTRIBUTE)
                .check(valueOf(LDAPPropertiesMapper.GROUP_USERNAMES_KEY), StringUtils::isBlank)
                .ifMatchesThenSet(message(i18nHelper, INVALID_GROUP_MEMBER))
                .build());

        return ruleListBuilder.build();
    }
}
