package com.atlassian.crowd.embedded.validator;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.validator.DirectoryValidationContext;

import java.util.EnumSet;

/**
 * Represents the factory for creating {@link Validator} instances
 *
 * @since 3.2.0
 */
public interface DirectoryValidatorFactory {
    /**
     * Creates instance of Directory validator with the given validation context and returns it
     *
     * @param directoryType
     *         Type of directory whose validator is required
     * @param directoryValidationContexts
     *         Set of {@link DirectoryValidationContext} according to which validator is constructed
     * @return {@link Validator} instance which will validate {@code directoryType}
     */
    Validator<Directory> getValidator(DirectoryType directoryType, EnumSet<DirectoryValidationContext> directoryValidationContexts);

}
