package com.atlassian.crowd.embedded.validator.impl;

import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.validator.DirectoryValidator;
import com.atlassian.crowd.embedded.validator.ValidationRule;
import com.atlassian.crowd.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

import static com.atlassian.crowd.embedded.validator.rule.DirectoryRuleBuilder.ruleFor;
import static com.atlassian.crowd.embedded.validator.rule.DirectoryRuleBuilder.valueOf;
import static com.atlassian.crowd.embedded.validator.rule.RuleBuilder.message;

public class LDAPUserSearchConfigValidator extends DirectoryValidator {

    public LDAPUserSearchConfigValidator(I18nHelper i18nHelper) {
        super(i18nHelper);
    }

    @Override
    protected List<ValidationRule<Directory>> initializeValidators(I18nHelper i18nHelper) {
        final ImmutableList.Builder<ValidationRule<Directory>> ruleListBuilder = ImmutableList.builder();

        ruleListBuilder.add(ruleFor(LDAPUserConfigValidator.USER_OBJECT_FILTER)
                .check(valueOf(LDAPPropertiesMapper.USER_OBJECTFILTER_KEY), StringUtils::isBlank)
                .ifMatchesThenSet(message(i18nHelper, DirectoryValidatorMessages.USER_CONFIGURATION.INVALID_USER_OBJECT_FILTER))
                .build());

        ruleListBuilder.add(ruleFor(LDAPUserConfigValidator.USER_NAME_ATTRIBUTE)
                .check(valueOf(LDAPPropertiesMapper.USER_USERNAME_KEY), StringUtils::isBlank)
                .ifMatchesThenSet(message(i18nHelper, DirectoryValidatorMessages.USER_CONFIGURATION.INVALID_USERNAME))
                .build());

        return ruleListBuilder.build();
    }

}
