package com.atlassian.crowd.embedded.validator.impl;

public interface DirectoryValidatorMessages {

    interface DIRECTORY {
        String INVALID_NAME = "directoryinternal.name.invalid";
        String NAME_ALREADY_EXISTS = "invalid.namealreadyexist.directory";
    }

    interface CUSTOM_DIRECTORY {
        String INVALID_IMPL_CLASS = "directorycustom.implementationclass.invalid";
    }

    interface INTERNAL_DIRECTORY {
        String INVALID_PASSWORD_REGEX_PATTERN = "directoryinternal.passwordregex.invalid";
        String INVALID_PASSWORD_MAX_CHANGE_TIME = "directoryinternal.passwordmaxchangetime.invalid";
        String INVALID_PASSWORD_MAX_AUTHENTICATE_ATTEMPTS = "directoryinternal.passwordmaxattempts.invalid";
        String INVALID_PASSWORD_HISTORY_COUNTS = "directoryinternal.passwordhistorycount.invalid";
        String INVALID_USER_ENCRYPTION_METHOD = "directoryinternal.userencryptionmethod.invalid";
        String INVALID_REMIND_PERIODS_FORMAT = "directoryinternal.remindperiods.invalid.format";
        String INVALID_REMIND_PERIODS_VALUES = "directoryinternal.remindperiods.invalid.values";
        String MAX_PASSWORD_CHANGE_TIME_TOO_LOW = "directoryinternal.passwordmaxchangetime.too.low";
    }

    interface AZURE_AD {
        String INVALID_GRAPH_API = "directory.azure.ad.graph.api.invalid";
        String INVALID_AUTHORITY_API = "directory.azure.ad.authority.api.invalid";
        String INVALID_WEBAPP_ID = "directory.azure.ad.web.app.id.invalid";
        String INVALID_WEBAPP_SECRET = "directory.azure.ad.web.app.secret.invalid";
        String INVALID_NATIVE_APP_ID = "directory.azure.ad.native.app.id.invalid";
        String INVALID_TENANT_ID = "directory.azure.ad.tenant.id.invalid";
        String INVALID_READ_TIMEOUT = "directory.azure.ad.read.timeout.invalid";
        String INVALID_CONNECTION_TIMEOUT = "directory.azure.ad.connection.timeout.invalid";
    }

    interface LDAP_CONNECTION {
        String INVALID_CONNECTOR_URL = "directoryconnector.url.invalid";
        String EMPTY_BASE_DN = "directoryconnector.basedn.invalid.blank";
        String INVALID_BASE_DN = "directoryconnector.basedn.invalid";
        String INVALID_PAGE_SIZE = "directoryconnector.pagedresultscontrolsize.invalid";
        String LOCAL_USER_STATUS_WITHOUT_CACHE = "directoryconnector.localuserstatus.withoutcache.message";
        String LOCAL_GROUPS_ENABLED_WITHOUT_CACHE = "directoryconnector.localgroups.withoutcache.message";
    }

    interface GROUP_CONFIGURATION {
        String INVALID_GROUP_NAME = "directoryconnector.groupname.invalid";
        String INVALID_GROUP_DESCRIPTION = "directoryconnector.groupdescription.invalid";
        String INVALID_GROUP_MEMBER = "directoryconnector.groupmember.invalid";
        String INVALID_GROUP_OBJECT_CLASS = "directoryconnector.groupobjectclass.invalid";
        String INVALID_GROUP_OBJECT_FILTER = "directoryconnector.groupobjectfilter.invalid";
    }

    interface USER_CONFIGURATION {
        String INVALID_USER_FIRST_NAME = "directoryconnector.userfirstnameattribute.invalid";
        String INVALID_USER_GROUP = "directoryconnector.usermemberofattribute.invalid";
        String INVALID_USER_LAST_NAME = "directoryconnector.userlastnameattribute.invalid";
        String INVALID_USER_DISPLAY_NAME = "directoryconnector.userdisplaynameattribute.invalid";
        String INVALID_USER_MAIL = "directoryconnector.usermailattribute.invalid";
        String INVALID_USERNAME = "directoryconnector.usernameattribute.invalid";
        String INVALID_USERNAME_RDN = "directoryconnector.usernamerdnattribute.invalid";
        String INVALID_USER_OBJECT_FILTER = "directoryconnector.userobjectfilter.invalid";
        String INVALID_USER_OBJECT_CLASS = "directoryconnector.userobjectclass.invalid";
        String INVALID_USER_PASSWORD = "directoryconnector.userpassword.invalid";
    }

    interface SYNCHRONISATION_CONFIGURATION {
        String INVALID_POLLING_INTERVAL = "directory.polling.interval.invalid";
        String INVALID_CRON_EXPRESSION = "directory.polling.cron.invalid";
    }

    interface CROWD_DIRECTORY {
        String INVALID_APPLICATION_NAME = "directorycrowd.applicationname.invalid";
        String INVALID_PASSWORD = "directorycrowd.applicationpassword.invalid";
        String INVALID_HTTP_MAX_CONNECTIONS = "directorycrowd.http.maxconnections.invalid";
        String INVALID_HTTP_PROXY_PORT = "directorycrowd.proxy.port.invalid";
        String INVALID_CROWD_SERVER_URL = "directorycrowd.url.invalid";

        String CONNECTION_TEST_SUCCESS = "directorycrowd.testconnection.success";
        String CONNECTION_TEST_FAILURE = "directorycrowd.testconnection.invalid";
    }

}
