package com.atlassian.crowd.embedded.validator.impl;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.validator.DirectoryValidator;
import com.atlassian.crowd.embedded.validator.ValidationRule;
import com.atlassian.crowd.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import org.apache.commons.lang3.StringUtils;

import java.util.List;

import static com.atlassian.crowd.embedded.validator.rule.DirectoryRuleBuilder.ruleFor;
import static com.atlassian.crowd.embedded.validator.rule.RuleBuilder.message;

public class CustomDirectoryValidator extends DirectoryValidator {

    public static final String IMPLEMENTATION_CLASS_FIELD = "implementationClass";

    public CustomDirectoryValidator(I18nHelper i18nHelper) {
        super(i18nHelper);
    }

    @Override
    protected List<ValidationRule<Directory>> initializeValidators(I18nHelper i18nHelper) {
        return ImmutableList.of(ruleFor(IMPLEMENTATION_CLASS_FIELD)
                .check(Directory::getImplementationClass, StringUtils::isBlank)
                .ifMatchesThenSet(message(i18nHelper, DirectoryValidatorMessages.CUSTOM_DIRECTORY.INVALID_IMPL_CLASS))
                .build());
    }
}
