package com.atlassian.crowd.embedded.validator;

import com.atlassian.crowd.validator.ValidationError;

import java.util.List;

/**
 * Interface for the entity validators
 *
 * @param <T>
 *         Type of entity to be validated by this validator implementation
 * @since 3.2.0
 */
public interface Validator<T> {

    /**
     * Will validate the given entity and return {@link List} generated during validation
     *
     * @param entity
     *         Entity to be validated
     * @return a {@link List} containing the errors or empty list if no error were generated
     */
    List<ValidationError> validate(T entity);

}
