package com.atlassian.crowd.embedded.validator;

import com.atlassian.crowd.validator.ValidationError;

import java.util.Objects;

public class FieldValidationError implements ValidationError {

    private final String fieldName;

    private final String message;

    public static FieldValidationError of(String inputKey, String message) {
        return new FieldValidationError(inputKey, message);
    }

    private FieldValidationError(String inputKey, String message) {
        this.fieldName = inputKey;
        this.message = message;
    }

    @Override
    public String getFieldName() {
        return fieldName;
    }

    @Override
    public String getErrorMessage() {
        return message;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        FieldValidationError that = (FieldValidationError) o;
        return Objects.equals(fieldName, that.fieldName) &&
                Objects.equals(message, that.message);
    }

    @Override
    public int hashCode() {
        return Objects.hash(fieldName, message);
    }
}
