/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.validator.impl;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.validator.DirectoryValidator;
import com.atlassian.crowd.embedded.validator.ValidationRule;
import com.atlassian.crowd.embedded.validator.rule.DirectoryRuleBuilder;
import com.atlassian.crowd.embedded.validator.rule.RuleBuilder;
import com.atlassian.crowd.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class InternalDirectoryValidator
extends DirectoryValidator {
    public static final String PASSWORD_REGEX = "passwordRegex";
    public static final String PASSWORD_MAX_CHANGE_TIME = "passwordMaxChangeTime";
    public static final String PASSWORD_MAX_AUTHENTICATE_ATTEMPTS = "passwordMaxAttempts";
    public static final String PASSWORD_HISTORY_COUNT = "passwordHistoryCount";
    public static final String USER_ENCRYPTION_METHOD = "userEncryptionMethod";

    public InternalDirectoryValidator(I18nHelper i18nHelper) {
        super(i18nHelper);
    }

    @Override
    protected List<ValidationRule<Directory>> initializeValidators(I18nHelper i18nHelper) {
        ImmutableList.Builder ruleListBuilder = ImmutableList.builder();
        ruleListBuilder.add(DirectoryRuleBuilder.ruleFor(PASSWORD_REGEX).check(DirectoryRuleBuilder.valueOf("password_regex"), RuleBuilder.not(RuleBuilder.isValidRegex())).ifMatchesThenSet(RuleBuilder.message(i18nHelper, "directoryinternal.passwordregex.invalid")).build());
        ruleListBuilder.add(DirectoryRuleBuilder.ruleFor(PASSWORD_MAX_AUTHENTICATE_ATTEMPTS).check(DirectoryRuleBuilder.valueOf("password_max_attempts"), RuleBuilder.not(RuleBuilder.greaterThanOrEquals(0L))).ifMatchesThenSet(RuleBuilder.message(i18nHelper, "directoryinternal.passwordmaxattempts.invalid")).build());
        ruleListBuilder.add(DirectoryRuleBuilder.ruleFor(PASSWORD_MAX_CHANGE_TIME).check(DirectoryRuleBuilder.valueOf("password_max_change_time"), RuleBuilder.not(RuleBuilder.greaterThanOrEquals(0L))).ifMatchesThenSet(RuleBuilder.message(i18nHelper, "directoryinternal.passwordmaxchangetime.invalid")).build());
        ruleListBuilder.add(DirectoryRuleBuilder.ruleFor(PASSWORD_HISTORY_COUNT).check(DirectoryRuleBuilder.valueOf("password_history_count"), RuleBuilder.not(RuleBuilder.greaterThanOrEquals(0L))).ifMatchesThenSet(RuleBuilder.message(i18nHelper, "directoryinternal.passwordhistorycount.invalid")).build());
        ruleListBuilder.add(DirectoryRuleBuilder.ruleFor(USER_ENCRYPTION_METHOD).check(DirectoryRuleBuilder.valueOf("user_encryption_method"), StringUtils::isBlank).ifMatchesThenSet(RuleBuilder.message(i18nHelper, "directoryinternal.userencryptionmethod.invalid")).build());
        return ruleListBuilder.build();
    }
}

