/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.core;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.GroupWithAttributes;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.core.DelegatingCrowdService;
import com.atlassian.crowd.embedded.core.FilteredGroupsProvider;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.embedded.InvalidGroupException;
import com.atlassian.crowd.exception.runtime.GroupNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.exception.runtime.UserNotFoundException;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.query.entity.AliasQuery;
import com.atlassian.crowd.search.query.entity.ApplicationQuery;
import com.atlassian.crowd.search.query.entity.DirectoryQuery;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.TokenQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.membership.GroupMembersOfGroupQuery;
import com.atlassian.crowd.search.query.membership.GroupMembershipQuery;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.query.membership.UserMembersOfGroupQuery;
import com.atlassian.crowd.search.query.membership.UserMembershipQuery;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class FilteredCrowdServiceImpl
extends DelegatingCrowdService {
    private final Set<Class<? extends Query>> SUPPORTED_QUERY_TYPES = ImmutableSet.of(TokenQuery.class, DirectoryQuery.class, AliasQuery.class, GroupQuery.class, ApplicationQuery.class, UserQuery.class, (Object[])new Class[]{MembershipQuery.class, UserMembersOfGroupQuery.class, GroupMembershipQuery.class, UserMembershipQuery.class, GroupMembersOfGroupQuery.class});
    private final Set<String> filteredGroups;

    public FilteredCrowdServiceImpl(CrowdService crowdService, FilteredGroupsProvider groupProvider) {
        super(crowdService);
        this.filteredGroups = ImmutableSet.copyOf((Collection)Collections2.transform(groupProvider.getGroups(), (Function)IdentifierUtils.TO_LOWER_CASE));
    }

    @Override
    public Group getGroup(String name) {
        if (this.isGroupToBeFiltered(name)) {
            return null;
        }
        return super.getGroup(name);
    }

    @Override
    public GroupWithAttributes getGroupWithAttributes(String name) {
        if (this.isGroupToBeFiltered(name)) {
            return null;
        }
        return super.getGroupWithAttributes(name);
    }

    @Override
    public <T> Iterable<T> search(Query<T> query) {
        if (!this.SUPPORTED_QUERY_TYPES.contains(query.getClass())) {
            throw new IllegalStateException("The query type [" + query.getClass() + "] is not understood by [" + this.getClass().getName() + "].");
        }
        if (this.filteredGroups.size() > 0) {
            if (query instanceof GroupQuery) {
                GroupQuery extendedQuery = new GroupQuery(query.getReturnType(), ((GroupQuery)query).getGroupType(), query.getSearchRestriction(), 0, query.getMaxResults() == -1 ? -1 : query.getStartIndex() + query.getMaxResults() + this.filteredGroups.size());
                Iterable result = this.filterGroups(super.search(extendedQuery), query);
                Iterator iterator = result.iterator();
                FilteredCrowdServiceImpl.advance(iterator, query.getStartIndex());
                ImmutableList results = query.getMaxResults() == -1 ? ImmutableList.copyOf(iterator) : ImmutableList.copyOf((Iterator)Iterators.limit(iterator, (int)query.getMaxResults()));
                return results;
            }
            if (query instanceof MembershipQuery) {
                return this.searchByMembershipQuery((MembershipQuery)query);
            }
        }
        return super.search(query);
    }

    private static int advance(Iterator<?> iterator, int count) {
        int skipped;
        for (skipped = 0; skipped < count && iterator.hasNext(); ++skipped) {
            iterator.next();
        }
        return skipped;
    }

    private <T> Iterable<T> filterGroups(Iterable<T> result, Query<T> query) {
        if (String.class.equals((Object)query.getReturnType())) {
            return Iterables.filter(result, (Predicate)new Predicate<T>(){

                public boolean apply(T groupname) {
                    return !FilteredCrowdServiceImpl.this.isGroupToBeFiltered((String)groupname);
                }
            });
        }
        if (Group.class.equals((Object)query.getReturnType())) {
            return Iterables.filter(result, (Predicate)new Predicate<T>(){

                public boolean apply(T group) {
                    return !FilteredCrowdServiceImpl.this.isGroupToBeFiltered((Group)group);
                }
            });
        }
        throw new IllegalArgumentException("return type of GroupQuery cannot be " + query.getReturnType().getName());
    }

    private <T> Iterable<T> searchByMembershipQuery(MembershipQuery<T> query) {
        if (query.getEntityToMatch().equals((Object)EntityDescriptor.group()) && this.isGroupToBeFiltered(query.getEntityNameToMatch())) {
            return Collections.emptyList();
        }
        if (query.getEntityToReturn().equals((Object)EntityDescriptor.group())) {
            Iterable<T> result = super.search(query);
            return this.filterGroups(result, (Query<T>)query);
        }
        return super.search(query);
    }

    @Override
    public boolean isUserMemberOfGroup(String userName, String groupName) {
        if (this.isGroupToBeFiltered(groupName)) {
            return false;
        }
        return super.isUserMemberOfGroup(userName, groupName);
    }

    @Override
    public boolean isUserMemberOfGroup(User user, Group group) {
        if (this.isGroupToBeFiltered(group.getName())) {
            return false;
        }
        return super.isUserMemberOfGroup(user, group);
    }

    @Override
    public boolean isGroupMemberOfGroup(String childGroupName, String parentGroupName) {
        if (this.isGroupToBeFiltered(childGroupName)) {
            return false;
        }
        if (this.isGroupToBeFiltered(parentGroupName)) {
            return false;
        }
        return super.isGroupMemberOfGroup(childGroupName, parentGroupName);
    }

    @Override
    public boolean isGroupMemberOfGroup(Group childGroup, Group parentGroup) {
        if (this.isGroupToBeFiltered(childGroup.getName())) {
            return false;
        }
        if (this.isGroupToBeFiltered(parentGroup.getName())) {
            return false;
        }
        return super.isGroupMemberOfGroup(childGroup, parentGroup);
    }

    @Override
    public Group addGroup(Group group) throws InvalidGroupException, OperationNotPermittedException, OperationFailedException {
        if (this.isGroupToBeFiltered(group)) {
            throw new OperationNotPermittedException("group name [" + group.getName() + "] is reserved. cannot add.");
        }
        return super.addGroup(group);
    }

    @Override
    public Group updateGroup(Group group) throws GroupNotFoundException, InvalidGroupException, OperationNotPermittedException, OperationFailedException {
        this.throwGroupNotFoundIfGroupIsToBeFiltered(group);
        return super.updateGroup(group);
    }

    @Override
    public void setGroupAttribute(Group group, String attributeName, String attributeValue) throws GroupNotFoundException, OperationNotPermittedException, OperationFailedException {
        this.throwGroupNotFoundIfGroupIsToBeFiltered(group);
        super.setGroupAttribute(group, attributeName, attributeValue);
    }

    @Override
    public void setGroupAttribute(Group group, String attributeName, Set<String> attributeValues) throws GroupNotFoundException, OperationNotPermittedException, OperationFailedException {
        this.throwGroupNotFoundIfGroupIsToBeFiltered(group);
        super.setGroupAttribute(group, attributeName, attributeValues);
    }

    @Override
    public void removeGroupAttribute(Group group, String attributeName) throws GroupNotFoundException, OperationNotPermittedException, OperationFailedException {
        this.throwGroupNotFoundIfGroupIsToBeFiltered(group);
        super.removeGroupAttribute(group, attributeName);
    }

    @Override
    public void removeAllGroupAttributes(Group group) throws GroupNotFoundException, OperationNotPermittedException, OperationFailedException {
        this.throwGroupNotFoundIfGroupIsToBeFiltered(group);
        super.removeAllGroupAttributes(group);
    }

    @Override
    public boolean removeGroup(Group group) throws OperationNotPermittedException, OperationFailedException {
        if (this.isGroupToBeFiltered(group)) {
            return false;
        }
        return super.removeGroup(group);
    }

    @Override
    public boolean addUserToGroup(User user, Group group) throws GroupNotFoundException, UserNotFoundException, OperationNotPermittedException, OperationFailedException {
        this.throwGroupNotFoundIfGroupIsToBeFiltered(group);
        return super.addUserToGroup(user, group);
    }

    @Override
    public boolean addGroupToGroup(Group childGroup, Group parentGroup) throws GroupNotFoundException, OperationNotPermittedException, InvalidMembershipException, OperationFailedException {
        this.throwGroupNotFoundIfGroupIsToBeFiltered(childGroup);
        this.throwGroupNotFoundIfGroupIsToBeFiltered(parentGroup);
        return super.addGroupToGroup(childGroup, parentGroup);
    }

    @Override
    public boolean removeUserFromGroup(User user, Group group) throws GroupNotFoundException, UserNotFoundException, OperationNotPermittedException, OperationFailedException {
        this.throwGroupNotFoundIfGroupIsToBeFiltered(group);
        return super.removeUserFromGroup(user, group);
    }

    @Override
    public boolean removeGroupFromGroup(Group childGroup, Group parentGroup) throws GroupNotFoundException, OperationNotPermittedException, OperationFailedException {
        this.throwGroupNotFoundIfGroupIsToBeFiltered(childGroup);
        this.throwGroupNotFoundIfGroupIsToBeFiltered(parentGroup);
        return super.removeGroupFromGroup(childGroup, parentGroup);
    }

    @Override
    public boolean isUserDirectGroupMember(User user, Group group) throws OperationFailedException {
        if (this.isGroupToBeFiltered(group)) {
            return false;
        }
        return super.isUserDirectGroupMember(user, group);
    }

    @Override
    public boolean isGroupDirectGroupMember(Group childGroup, Group parentGroup) throws OperationFailedException {
        if (this.isGroupToBeFiltered(childGroup) || this.isGroupToBeFiltered(parentGroup)) {
            return false;
        }
        return super.isGroupDirectGroupMember(childGroup, parentGroup);
    }

    private boolean isGroupToBeFiltered(String groupname) {
        return this.filteredGroups.contains(IdentifierUtils.toLowerCase((String)groupname));
    }

    private boolean isGroupToBeFiltered(Group group) {
        return this.isGroupToBeFiltered(group.getName());
    }

    private void throwGroupNotFoundIfGroupIsToBeFiltered(Group group) throws GroupNotFoundException {
        if (this.isGroupToBeFiltered(group.getName())) {
            throw new GroupNotFoundException(group.getName());
        }
    }
}

