/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.core;

import com.atlassian.crowd.core.tiny.ClassLoaderUtils;
import com.atlassian.crowd.embedded.core.FilteredGroupsProvider;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XmlFilteredGroupsProvider
implements FilteredGroupsProvider {
    private final FilteredGroupsFileReader fileReader;

    public XmlFilteredGroupsProvider() {
        this.fileReader = new ClassPathFilteredGroupsFileReader();
    }

    public XmlFilteredGroupsProvider(FilteredGroupsFileReader fileReader) {
        this.fileReader = fileReader;
    }

    @Override
    public Set<String> getGroups() {
        Document doc;
        InputStream stream = this.fileReader.getStream();
        if (stream == null) {
            return Collections.emptySet();
        }
        SAXReader reader = new SAXReader();
        try {
            doc = reader.read(stream);
        }
        catch (DocumentException e) {
            throw new IllegalStateException("Cannot read filtered group file. make sure it is well-formed.", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return this.parse(doc);
    }

    private Set<String> parse(Document doc) {
        HashSet<String> groups = new HashSet<String>();
        Element root = doc.getRootElement();
        if (root.getName().equals("filteredgroups")) {
            for (Element elem : root.elements()) {
                if (!elem.getName().equals("filteredgroup")) continue;
                groups.add(elem.getTextTrim());
            }
        }
        return groups;
    }

    static class ClassPathFilteredGroupsFileReader
    implements FilteredGroupsFileReader {
        private static final String FILTERED_GROUPS_FILE = "crowd-filtered-groups.xml";

        ClassPathFilteredGroupsFileReader() {
        }

        private String getFilename() {
            return System.getProperty("crowd.service.filteredgroups.file", FILTERED_GROUPS_FILE);
        }

        @Override
        public InputStream getStream() {
            return ClassLoaderUtils.getResourceAsStream((String)this.getFilename(), this.getClass());
        }
    }

    static interface FilteredGroupsFileReader {
        public InputStream getStream();
    }
}

