/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.directory;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.math.NumberUtils;

public class LdapDirectoryAttributes {
    private String ldapUrl;
    private String ldapBasedn;
    private String ldapUserdn;
    private boolean ldapSecure;
    private String ldapPassword;
    private boolean ldapPropogateChanges;
    private String ldapUserDn;
    private String ldapGroupDn;
    private boolean ldapNestedgroupsDisabled;
    private boolean rolesDisabled = true;
    private boolean ldapPagedresults;
    private String ldapPagedresultsSize;
    private boolean ldapReferral;
    private boolean ldapUsermembershipUseForGroups;
    private boolean ldapUsermembershipUse;
    private boolean ldapRelaxedDnStandardisation;
    private String ldapUserEncryption;
    private String ldapUserObjectclass;
    private String ldapUserFilter;
    private String ldapUserUsername;
    private String ldapUserUsernameRdn;
    private String ldapUserFirstname;
    private String ldapUserLastname;
    private String ldapUserDisplayname;
    private String ldapUserEmail;
    private String ldapUserGroup;
    private String ldapUserPassword;
    private String ldapGroupObjectclass;
    private String ldapGroupFilter;
    private String ldapGroupName;
    private String ldapGroupDescription;
    private String ldapGroupUsernames;
    private boolean localGroups;
    private boolean incrementalSyncEnabled;
    private String ldapCacheSynchroniseIntervalInMin;
    private String ldapPoolInitSize;
    private String ldapPoolPrefSize;
    private String ldapPoolMaxSize;
    private String ldapPoolTimeoutInSec;
    private String ldapConnectionTimeoutInSec;
    private String ldapReadTimeoutInSec;
    private String ldapSearchTimelimitInSec;
    private String ldapAutoAddGroups;

    public String getLdapUrl() {
        return this.ldapUrl;
    }

    public void setLdapUrl(String ldapUrl) {
        this.ldapUrl = ldapUrl;
    }

    public boolean isLdapSecure() {
        return this.ldapSecure;
    }

    public void setLdapSecure(boolean ldapSecure) {
        this.ldapSecure = ldapSecure;
    }

    public String getLdapBasedn() {
        return this.ldapBasedn;
    }

    public void setLdapBasedn(String ldapBasedn) {
        this.ldapBasedn = ldapBasedn;
    }

    public String getLdapUserdn() {
        return this.ldapUserdn;
    }

    public void setLdapUserdn(String ldapUserdn) {
        this.ldapUserdn = ldapUserdn;
    }

    public String getLdapPassword() {
        return this.ldapPassword;
    }

    public void setLdapPassword(String ldapPassword) {
        this.ldapPassword = ldapPassword;
    }

    public boolean isLdapPropogateChanges() {
        return this.ldapPropogateChanges;
    }

    public void setLdapPropogateChanges(boolean ldapPropogateChanges) {
        this.ldapPropogateChanges = ldapPropogateChanges;
    }

    public String getLdapUserDn() {
        return this.ldapUserDn;
    }

    public void setLdapUserDn(String ldapUserDn) {
        this.ldapUserDn = ldapUserDn;
    }

    public String getLdapGroupDn() {
        return this.ldapGroupDn;
    }

    public void setLdapGroupDn(String ldapGroupDn) {
        this.ldapGroupDn = ldapGroupDn;
    }

    public boolean isLdapNestedgroupsDisabled() {
        return this.ldapNestedgroupsDisabled;
    }

    public void setLdapNestedgroupsDisabled(boolean ldapNestedgroupsDisabled) {
        this.ldapNestedgroupsDisabled = ldapNestedgroupsDisabled;
    }

    public boolean isRolesDisabled() {
        return this.rolesDisabled;
    }

    public void setRolesDisabled(boolean rolesDisabled) {
        this.rolesDisabled = rolesDisabled;
    }

    public boolean isLdapPagedresults() {
        return this.ldapPagedresults;
    }

    public void setLdapPagedresults(boolean ldapPagedresults) {
        this.ldapPagedresults = ldapPagedresults;
    }

    public String getLdapPagedresultsSize() {
        return this.ldapPagedresultsSize;
    }

    public void setLdapPagedresultsSize(String ldapPagedresultsSize) {
        this.ldapPagedresultsSize = ldapPagedresultsSize;
    }

    public boolean isLdapReferral() {
        return this.ldapReferral;
    }

    public void setLdapReferral(boolean ldapReferral) {
        this.ldapReferral = ldapReferral;
    }

    public boolean isLdapUsermembershipUseForGroups() {
        return this.ldapUsermembershipUseForGroups;
    }

    public void setLdapUsermembershipUseForGroups(boolean ldapUsermembershipUseForGroups) {
        this.ldapUsermembershipUseForGroups = ldapUsermembershipUseForGroups;
    }

    public boolean isLdapUsermembershipUse() {
        return this.ldapUsermembershipUse;
    }

    public void setLdapUsermembershipUse(boolean ldapUsermembershipUse) {
        this.ldapUsermembershipUse = ldapUsermembershipUse;
    }

    public boolean isLdapRelaxedDnStandardisation() {
        return this.ldapRelaxedDnStandardisation;
    }

    public void setLdapRelaxedDnStandardisation(boolean ldapRelaxedDnStandardisation) {
        this.ldapRelaxedDnStandardisation = ldapRelaxedDnStandardisation;
    }

    public String getLdapUserEncryption() {
        return this.ldapUserEncryption;
    }

    public void setLdapUserEncryption(String ldapUserEncryption) {
        this.ldapUserEncryption = ldapUserEncryption;
    }

    public String getLdapUserObjectclass() {
        return this.ldapUserObjectclass;
    }

    public void setLdapUserObjectclass(String ldapUserObjectclass) {
        this.ldapUserObjectclass = ldapUserObjectclass;
    }

    public String getLdapUserFilter() {
        return this.ldapUserFilter;
    }

    public void setLdapUserFilter(String ldapUserFilter) {
        this.ldapUserFilter = ldapUserFilter;
    }

    public String getLdapUserUsername() {
        return this.ldapUserUsername;
    }

    public void setLdapUserUsername(String ldapUserUsername) {
        this.ldapUserUsername = ldapUserUsername;
    }

    public String getLdapUserUsernameRdn() {
        return this.ldapUserUsernameRdn;
    }

    public void setLdapUserUsernameRdn(String ldapUserUsernameRdn) {
        this.ldapUserUsernameRdn = ldapUserUsernameRdn;
    }

    public String getLdapUserFirstname() {
        return this.ldapUserFirstname;
    }

    public void setLdapUserFirstname(String ldapUserFirstname) {
        this.ldapUserFirstname = ldapUserFirstname;
    }

    public String getLdapUserLastname() {
        return this.ldapUserLastname;
    }

    public void setLdapUserLastname(String ldapUserLastname) {
        this.ldapUserLastname = ldapUserLastname;
    }

    public String getLdapUserDisplayname() {
        return this.ldapUserDisplayname;
    }

    public void setLdapUserDisplayname(String ldapUserDisplayname) {
        this.ldapUserDisplayname = ldapUserDisplayname;
    }

    public String getLdapUserEmail() {
        return this.ldapUserEmail;
    }

    public void setLdapUserEmail(String ldapUserEmail) {
        this.ldapUserEmail = ldapUserEmail;
    }

    public String getLdapUserGroup() {
        return this.ldapUserGroup;
    }

    public void setLdapUserGroup(String ldapUserGroup) {
        this.ldapUserGroup = ldapUserGroup;
    }

    public String getLdapUserPassword() {
        return this.ldapUserPassword;
    }

    public void setLdapUserPassword(String ldapUserPassword) {
        this.ldapUserPassword = ldapUserPassword;
    }

    public String getLdapGroupObjectclass() {
        return this.ldapGroupObjectclass;
    }

    public void setLdapGroupObjectclass(String ldapGroupObjectclass) {
        this.ldapGroupObjectclass = ldapGroupObjectclass;
    }

    public String getLdapGroupFilter() {
        return this.ldapGroupFilter;
    }

    public void setLdapGroupFilter(String ldapGroupFilter) {
        this.ldapGroupFilter = ldapGroupFilter;
    }

    public String getLdapGroupName() {
        return this.ldapGroupName;
    }

    public void setLdapGroupName(String ldapGroupName) {
        this.ldapGroupName = ldapGroupName;
    }

    public String getLdapGroupDescription() {
        return this.ldapGroupDescription;
    }

    public void setLdapGroupDescription(String ldapGroupDescription) {
        this.ldapGroupDescription = ldapGroupDescription;
    }

    public String getLdapGroupUsernames() {
        return this.ldapGroupUsernames;
    }

    public void setLdapGroupUsernames(String ldapGroupUsernames) {
        this.ldapGroupUsernames = ldapGroupUsernames;
    }

    public boolean isIncrementalSyncEnabled() {
        return this.incrementalSyncEnabled;
    }

    public void setIncrementalSyncEnabled(boolean incrementalSyncEnabled) {
        this.incrementalSyncEnabled = incrementalSyncEnabled;
    }

    public String getLdapCacheSynchroniseIntervalInMin() {
        return this.ldapCacheSynchroniseIntervalInMin;
    }

    public void setLdapCacheSynchroniseIntervalInMin(String ldapCacheSynchroniseIntervalInMin) {
        this.ldapCacheSynchroniseIntervalInMin = ldapCacheSynchroniseIntervalInMin;
    }

    public boolean isLocalGroups() {
        return this.localGroups;
    }

    public void setLocalGroups(boolean localGroups) {
        this.localGroups = localGroups;
    }

    public String getLdapPoolInitSize() {
        return this.ldapPoolInitSize;
    }

    public void setLdapPoolInitSize(String ldapPoolInitSize) {
        this.ldapPoolInitSize = ldapPoolInitSize;
    }

    public String getLdapPoolMaxSize() {
        return this.ldapPoolMaxSize;
    }

    public void setLdapPoolMaxSize(String ldapPoolMaxSize) {
        this.ldapPoolMaxSize = ldapPoolMaxSize;
    }

    public String getLdapPoolPrefSize() {
        return this.ldapPoolPrefSize;
    }

    public void setLdapPoolPrefSize(String ldapPoolPrefSize) {
        this.ldapPoolPrefSize = ldapPoolPrefSize;
    }

    public String getLdapConnectionTimeoutInSec() {
        return this.ldapConnectionTimeoutInSec;
    }

    public void setLdapConnectionTimeoutInSec(String ldapConnectionTimeoutInSec) {
        this.ldapConnectionTimeoutInSec = ldapConnectionTimeoutInSec;
    }

    public String getLdapPoolTimeoutInSec() {
        return this.ldapPoolTimeoutInSec;
    }

    public void setLdapPoolTimeoutInSec(String ldapPoolTimeoutInSec) {
        this.ldapPoolTimeoutInSec = ldapPoolTimeoutInSec;
    }

    public String getLdapReadTimeoutInSec() {
        return this.ldapReadTimeoutInSec;
    }

    public void setLdapReadTimeoutInSec(String ldapReadTimeoutInSec) {
        this.ldapReadTimeoutInSec = ldapReadTimeoutInSec;
    }

    public String getLdapSearchTimelimitInSec() {
        return this.ldapSearchTimelimitInSec;
    }

    public void setLdapSearchTimelimitInSec(String ldapSearchTimelimitInSec) {
        this.ldapSearchTimelimitInSec = ldapSearchTimelimitInSec;
    }

    public void setLdapAutoAddGroups(String groups) {
        this.ldapAutoAddGroups = groups;
    }

    public String getLdapAutoAddGroups() {
        return this.ldapAutoAddGroups;
    }

    public Map<String, String> toAttributesMap() {
        HashMap<String, String> map = new HashMap<String, String>(50);
        this.addAttributeToMap(map, "ldap.url", this.ldapUrl);
        this.addAttributeToMap(map, "ldap.secure", String.valueOf(this.ldapSecure));
        this.addAttributeToMap(map, "ldap.basedn", this.ldapBasedn);
        this.addAttributeToMap(map, "ldap.userdn", this.ldapUserdn);
        this.addAttributeToMap(map, "ldap.password", this.ldapPassword);
        this.addAttributeToMap(map, "ldap.propogate.changes", String.valueOf(this.ldapPropogateChanges));
        this.addAttributeToMap(map, "ldap.user.dn", this.ldapUserDn);
        this.addAttributeToMap(map, "ldap.group.dn", this.ldapGroupDn);
        this.addAttributeToMap(map, "ldap.nestedgroups.disabled", String.valueOf(this.ldapNestedgroupsDisabled));
        this.addAttributeToMap(map, "ldap.roles.disabled", String.valueOf(this.rolesDisabled));
        this.addAttributeToMap(map, "ldap.pagedresults", String.valueOf(this.ldapPagedresults));
        this.addAttributeToMap(map, "ldap.pagedresults.size", this.ldapPagedresultsSize);
        this.addAttributeToMap(map, "ldap.referral", String.valueOf(this.ldapReferral));
        this.addAttributeToMap(map, "ldap.usermembership.use.for.groups", String.valueOf(this.ldapUsermembershipUseForGroups));
        this.addAttributeToMap(map, "ldap.usermembership.use", String.valueOf(this.ldapUsermembershipUse));
        this.addAttributeToMap(map, "ldap.relaxed.dn.standardisation", String.valueOf(this.ldapRelaxedDnStandardisation));
        this.addAttributeToMap(map, "ldap.user.encryption", this.ldapUserEncryption);
        this.addAttributeToMap(map, "ldap.user.objectclass", this.ldapUserObjectclass);
        this.addAttributeToMap(map, "ldap.user.filter", this.ldapUserFilter);
        this.addAttributeToMap(map, "ldap.user.username", this.ldapUserUsername);
        this.addAttributeToMap(map, "ldap.user.username.rdn", this.ldapUserUsernameRdn);
        this.addAttributeToMap(map, "ldap.user.firstname", this.ldapUserFirstname);
        this.addAttributeToMap(map, "ldap.user.lastname", this.ldapUserLastname);
        this.addAttributeToMap(map, "ldap.user.displayname", this.ldapUserDisplayname);
        this.addAttributeToMap(map, "ldap.user.email", this.ldapUserEmail);
        this.addAttributeToMap(map, "ldap.user.group", this.ldapUserGroup);
        this.addAttributeToMap(map, "ldap.user.password", this.ldapUserPassword);
        this.addAttributeToMap(map, "ldap.group.objectclass", this.ldapGroupObjectclass);
        this.addAttributeToMap(map, "ldap.group.filter", this.ldapGroupFilter);
        this.addAttributeToMap(map, "ldap.group.name", this.ldapGroupName);
        this.addAttributeToMap(map, "ldap.group.description", this.ldapGroupDescription);
        this.addAttributeToMap(map, "ldap.group.usernames", this.ldapGroupUsernames);
        this.addAttributeToMap(map, "ldap.local.groups", String.valueOf(this.localGroups));
        this.addAttributeToMap(map, "ldap.pool.initsize", this.ldapPoolInitSize);
        this.addAttributeToMap(map, "ldap.pool.prefsize", this.ldapPoolPrefSize);
        this.addAttributeToMap(map, "ldap.pool.maxsize", this.ldapPoolMaxSize);
        this.addAttributeToMap(map, "crowd.sync.incremental.enabled", String.valueOf(this.incrementalSyncEnabled));
        this.addAttributeToMap(map, "directory.cache.synchronise.interval", Long.toString(NumberUtils.toLong((String)this.ldapCacheSynchroniseIntervalInMin) * 60L));
        this.addAttributeToMap(map, "ldap.pool.timeout", Long.toString(TimeUnit.MILLISECONDS.convert(NumberUtils.toLong((String)this.ldapPoolTimeoutInSec), TimeUnit.SECONDS)));
        this.addAttributeToMap(map, "ldap.connection.timeout", Long.toString(TimeUnit.MILLISECONDS.convert(NumberUtils.toLong((String)this.ldapConnectionTimeoutInSec), TimeUnit.SECONDS)));
        this.addAttributeToMap(map, "ldap.read.timeout", Long.toString(TimeUnit.MILLISECONDS.convert(NumberUtils.toLong((String)this.ldapReadTimeoutInSec), TimeUnit.SECONDS)));
        this.addAttributeToMap(map, "ldap.search.timelimit", Long.toString(TimeUnit.MILLISECONDS.convert(NumberUtils.toLong((String)this.ldapSearchTimelimitInSec), TimeUnit.SECONDS)));
        map.put("autoAddGroups", this.ldapAutoAddGroups);
        return map;
    }

    private void addAttributeToMap(HashMap<String, String> map, String key, String value) {
        if (value != null && value.length() > 0) {
            map.put(key, value);
        }
    }

    public static LdapDirectoryAttributes fromAttributesMap(Map<String, String> map) {
        LdapDirectoryAttributes attributes = new LdapDirectoryAttributes();
        attributes.setLdapUrl(map.get("ldap.url"));
        attributes.setLdapSecure(Boolean.valueOf(map.get("ldap.secure")));
        attributes.setLdapBasedn(map.get("ldap.basedn"));
        attributes.setLdapUserdn(map.get("ldap.userdn"));
        attributes.setLdapPassword(map.get("ldap.password"));
        attributes.setLdapPropogateChanges(Boolean.valueOf(map.get("ldap.propogate.changes")));
        attributes.setLdapUserDn(map.get("ldap.user.dn"));
        attributes.setLdapGroupDn(map.get("ldap.group.dn"));
        attributes.setLdapNestedgroupsDisabled(Boolean.valueOf(map.get("ldap.nestedgroups.disabled")));
        attributes.setRolesDisabled(Boolean.valueOf(map.get("ldap.roles.disabled")));
        attributes.setLdapPagedresults(Boolean.valueOf(map.get("ldap.pagedresults")));
        attributes.setLdapPagedresultsSize(map.get("ldap.pagedresults.size"));
        attributes.setLdapReferral(Boolean.valueOf(map.get("ldap.referral")));
        attributes.setLdapUsermembershipUseForGroups(Boolean.valueOf(map.get("ldap.usermembership.use.for.groups")));
        attributes.setLdapUsermembershipUse(Boolean.valueOf(map.get("ldap.usermembership.use")));
        attributes.setLdapRelaxedDnStandardisation(Boolean.valueOf(map.get("ldap.relaxed.dn.standardisation")));
        attributes.setLdapUserEncryption(map.get("ldap.user.encryption"));
        attributes.setLdapUserObjectclass(map.get("ldap.user.objectclass"));
        attributes.setLdapUserFilter(map.get("ldap.user.filter"));
        attributes.setLdapUserUsername(map.get("ldap.user.username"));
        attributes.setLdapUserUsernameRdn(map.get("ldap.user.username.rdn"));
        attributes.setLdapUserFirstname(map.get("ldap.user.firstname"));
        attributes.setLdapUserLastname(map.get("ldap.user.lastname"));
        attributes.setLdapUserDisplayname(map.get("ldap.user.displayname"));
        attributes.setLdapUserEmail(map.get("ldap.user.email"));
        attributes.setLdapUserGroup(map.get("ldap.user.group"));
        attributes.setLdapUserPassword(map.get("ldap.user.password"));
        attributes.setLdapGroupObjectclass(map.get("ldap.group.objectclass"));
        attributes.setLdapGroupFilter(map.get("ldap.group.filter"));
        attributes.setLdapGroupName(map.get("ldap.group.name"));
        attributes.setLdapGroupDescription(map.get("ldap.group.description"));
        attributes.setLdapGroupUsernames(map.get("ldap.group.usernames"));
        attributes.setLocalGroups(Boolean.valueOf(map.get("ldap.local.groups")));
        attributes.setLdapPoolInitSize(map.get("ldap.pool.initsize"));
        attributes.setLdapPoolPrefSize(map.get("ldap.pool.prefsize"));
        attributes.setLdapPoolMaxSize(map.get("ldap.pool.maxsize"));
        attributes.setIncrementalSyncEnabled(Boolean.parseBoolean(map.get("crowd.sync.incremental.enabled")));
        attributes.setLdapCacheSynchroniseIntervalInMin(Long.toString(NumberUtils.toLong((String)map.get("directory.cache.synchronise.interval")) / 60L));
        attributes.setLdapPoolTimeoutInSec(Long.toString(TimeUnit.SECONDS.convert(NumberUtils.toLong((String)map.get("ldap.pool.timeout")), TimeUnit.MILLISECONDS)));
        attributes.setLdapConnectionTimeoutInSec(Long.toString(TimeUnit.SECONDS.convert(NumberUtils.toLong((String)map.get("ldap.connection.timeout")), TimeUnit.MILLISECONDS)));
        attributes.setLdapReadTimeoutInSec(Long.toString(TimeUnit.SECONDS.convert(NumberUtils.toLong((String)map.get("ldap.read.timeout")), TimeUnit.MILLISECONDS)));
        attributes.setLdapSearchTimelimitInSec(Long.toString(TimeUnit.SECONDS.convert(NumberUtils.toLong((String)map.get("ldap.search.timelimit")), TimeUnit.MILLISECONDS)));
        attributes.setLdapAutoAddGroups(map.get("autoAddGroups"));
        return attributes;
    }
}

