/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.impl;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public final class ImmutableAttributes
implements Attributes,
Serializable {
    private static final long serialVersionUID = -356796362241352598L;
    private final Map<String, Set<String>> map;

    public ImmutableAttributes() {
        this.map = Collections.emptyMap();
    }

    public ImmutableAttributes(@NotNull Map<String, Set<String>> attributesMap) {
        this.map = ImmutableAttributes.immutableCopyOf(attributesMap);
    }

    public ImmutableAttributes(@NotNull Attributes attributes) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : attributes.getKeys()) {
            builder.put((Object)key, (Object)ImmutableSet.copyOf((Iterable)attributes.getValues(key)));
        }
        this.map = builder.build();
    }

    public Set<String> getValues(String key) {
        return this.map.get(key);
    }

    public String getValue(String key) {
        Set<String> values = this.getValues(key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }

    public Set<String> getKeys() {
        return this.map.keySet();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private static Map<String, Set<String>> immutableCopyOf(Map<String, Set<String>> source) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, Set<String>> entry : source.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)ImmutableSet.copyOf((Iterable)entry.getValue()));
        }
        return builder.build();
    }
}

