/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.directory;

import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.ConnectionPoolProperties;
import com.atlassian.crowd.embedded.impl.DefaultConnectionPoolProperties;
import com.atlassian.crowd.event.application.ApplicationReadyEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import java.util.Map;
import org.apache.log4j.Logger;

public class LdapConnectionPoolInitialisationListener {
    private final Logger logger = Logger.getLogger(LdapConnectionPoolInitialisationListener.class);
    private final ApplicationFactory applicationFactory;

    public LdapConnectionPoolInitialisationListener(ApplicationFactory applicationFactory, EventPublisher eventPublisher) {
        this.applicationFactory = applicationFactory;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void handleEvent(ApplicationReadyEvent event) {
        Map attributes = this.applicationFactory.getApplication().getAttributes();
        ConnectionPoolProperties connectionPoolConfiguration = DefaultConnectionPoolProperties.fromPropertiesMap((Map)attributes);
        Map propertiesMap = connectionPoolConfiguration.toPropertiesMap();
        for (Map.Entry entry : propertiesMap.entrySet()) {
            if (entry.getValue() == null) continue;
            this.logger.debug((Object)("Setting system-wide LDAP connection pool property: <" + (String)entry.getKey() + "> with value: <" + (String)entry.getValue() + ">"));
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

