/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.core;

import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.ApplicationFactory;
import com.atlassian.crowd.embedded.api.ConnectionPoolProperties;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectorySynchronisationInformation;
import com.atlassian.crowd.embedded.impl.DefaultConnectionPoolProperties;
import com.atlassian.crowd.embedded.impl.SystemConnectionPoolProperties;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryCurrentlySynchronisingException;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CrowdDirectoryServiceImpl
implements CrowdDirectoryService {
    private final Logger logger = Logger.getLogger(CrowdDirectoryServiceImpl.class);
    private final DirectoryManager directoryManager;
    private final ApplicationManager applicationManager;
    private final ApplicationFactory applicationFactory;
    private final DirectoryInstanceLoader directoryInstanceLoader;
    private volatile boolean ldapConnectionPoolSettingsApplied;

    public CrowdDirectoryServiceImpl(ApplicationFactory applicationFactory, DirectoryInstanceLoader directoryInstanceLoader, DirectoryManager directoryManager, ApplicationManager applicationManager) {
        this.directoryManager = (DirectoryManager)Preconditions.checkNotNull((Object)directoryManager);
        this.applicationManager = (ApplicationManager)Preconditions.checkNotNull((Object)applicationManager);
        this.applicationFactory = (ApplicationFactory)Preconditions.checkNotNull((Object)applicationFactory);
        this.directoryInstanceLoader = (DirectoryInstanceLoader)Preconditions.checkNotNull((Object)directoryInstanceLoader);
    }

    public Directory addDirectory(Directory directory) throws OperationFailedException {
        try {
            return this.directoryManager.addDirectory(directory);
        }
        catch (DirectoryInstantiationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void testConnection(Directory directory) throws OperationFailedException {
        try {
            this.directoryInstanceLoader.getRawDirectory(directory.getId(), directory.getImplementationClass(), directory.getAttributes()).testConnection();
        }
        catch (DirectoryInstantiationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            throw new OperationFailedException(e.getMessage(), e.getCause());
        }
    }

    public List<Directory> findAllDirectories() {
        return Lists.transform((List)this.getApplication().getDirectoryMappings(), (Function)new Function<DirectoryMapping, Directory>(){

            public Directory apply(DirectoryMapping from) {
                return from.getDirectory();
            }
        });
    }

    public Directory findDirectoryById(long directoryId) {
        try {
            return this.directoryManager.findDirectoryById(directoryId);
        }
        catch (DirectoryNotFoundException e) {
            return null;
        }
    }

    public Directory updateDirectory(Directory directory) throws OperationFailedException {
        try {
            return this.directoryManager.updateDirectory(directory);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void setDirectoryPosition(long directoryId, int position) throws OperationFailedException {
        try {
            this.applicationManager.updateDirectoryMapping(this.getApplication(), this.findDirectoryById(directoryId), position);
        }
        catch (ApplicationNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public boolean removeDirectory(long directoryId) throws DirectoryCurrentlySynchronisingException, OperationFailedException {
        Directory directory = this.findDirectoryById(directoryId);
        if (directory != null) {
            try {
                this.directoryManager.removeDirectory(directory);
            }
            catch (DirectoryNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        return this.findDirectoryById(directoryId) != null;
    }

    public boolean supportsNestedGroups(long directoryId) throws OperationFailedException {
        try {
            return this.directoryManager.supportsNestedGroups(directoryId);
        }
        catch (DirectoryInstantiationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public boolean isDirectorySynchronisable(long directoryId) throws OperationFailedException {
        try {
            return this.directoryManager.isSynchronisable(directoryId);
        }
        catch (DirectoryInstantiationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void synchroniseDirectory(long directoryId) throws OperationFailedException {
        this.synchroniseDirectory(directoryId, true);
    }

    public void synchroniseDirectory(long directoryId, boolean runInBackground) throws OperationFailedException {
        try {
            this.directoryManager.synchroniseCache(directoryId, SynchronisationMode.FULL, runInBackground);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            throw new OperationFailedException(e.getMessage(), e.getCause());
        }
    }

    public boolean isDirectorySynchronising(long directoryId) throws OperationFailedException {
        try {
            return this.directoryManager.isSynchronising(directoryId);
        }
        catch (DirectoryInstantiationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public DirectorySynchronisationInformation getDirectorySynchronisationInformation(long directoryId) throws OperationFailedException {
        try {
            return this.directoryManager.getDirectorySynchronisationInformation(directoryId);
        }
        catch (DirectoryInstantiationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void setConnectionPoolProperties(ConnectionPoolProperties poolProperties) {
        ApplicationImpl template = ApplicationImpl.newInstance((Application)this.getApplication());
        template.getAttributes().putAll(poolProperties.toPropertiesMap());
        try {
            this.applicationManager.update((Application)template);
        }
        catch (ApplicationManagerException e) {
            throw new RuntimeException(e);
        }
        catch (ApplicationNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public ConnectionPoolProperties getStoredConnectionPoolProperties() {
        Map attributes = this.getApplication().getAttributes();
        return DefaultConnectionPoolProperties.fromPropertiesMap((Map)attributes);
    }

    private Application getApplication() {
        Application application = this.applicationFactory.getApplication();
        this.initialiseConnectionPoolSystemProperties(application);
        return application;
    }

    public ConnectionPoolProperties getSystemConnectionPoolProperties() {
        this.initialiseConnectionPoolSystemProperties();
        return SystemConnectionPoolProperties.getInstance();
    }

    private void initialiseConnectionPoolSystemProperties(Application application) {
        if (!this.ldapConnectionPoolSettingsApplied) {
            this.storeLdapConnectionPoolConfiguration(application);
            this.ldapConnectionPoolSettingsApplied = true;
        }
    }

    private void initialiseConnectionPoolSystemProperties() {
        this.initialiseConnectionPoolSystemProperties(this.getApplication());
    }

    private void storeLdapConnectionPoolConfiguration(Application application) {
        Map attributes = application.getAttributes();
        ConnectionPoolProperties connectionPoolConfiguration = DefaultConnectionPoolProperties.fromPropertiesMap((Map)attributes);
        Map propertiesMap = connectionPoolConfiguration.toPropertiesMap();
        for (Map.Entry entry : propertiesMap.entrySet()) {
            if (entry.getValue() == null) continue;
            this.logger.debug((Object)("Setting system-wide LDAP connection pool property: <" + (String)entry.getKey() + "> with value: <" + (String)entry.getValue() + ">"));
            System.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

