/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.impl;

import com.atlassian.crowd.embedded.api.ConnectionPoolProperties;
import com.atlassian.crowd.embedded.impl.ConnectionPoolPropertyUtil;
import java.util.LinkedHashMap;
import java.util.Map;

public enum SystemConnectionPoolProperties implements ConnectionPoolProperties
{
    INSTANCE;


    public static ConnectionPoolProperties getInstance() {
        return INSTANCE;
    }

    @Override
    public String getInitialSize() {
        return System.getProperty("com.sun.jndi.ldap.connect.pool.initsize");
    }

    @Override
    public String getMaximumSize() {
        return System.getProperty("com.sun.jndi.ldap.connect.pool.maxsize");
    }

    @Override
    public String getPreferredSize() {
        return System.getProperty("com.sun.jndi.ldap.connect.pool.prefsize");
    }

    @Override
    public String getSupportedProtocol() {
        return System.getProperty("com.sun.jndi.ldap.connect.pool.protocol");
    }

    @Override
    public String getTimeoutInSec() {
        String poolTimeoutSysProperty = SystemConnectionPoolProperties.getTimeoutInMillis();
        return poolTimeoutSysProperty != null ? ConnectionPoolPropertyUtil.millisToSeconds(poolTimeoutSysProperty) : null;
    }

    @Override
    public String getSupportedAuthentication() {
        return System.getProperty("com.sun.jndi.ldap.connect.pool.authentication");
    }

    @Override
    public Map<String, String> toPropertiesMap() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("com.sun.jndi.ldap.connect.pool.initsize", this.getInitialSize());
        result.put("com.sun.jndi.ldap.connect.pool.maxsize", this.getMaximumSize());
        result.put("com.sun.jndi.ldap.connect.pool.prefsize", this.getPreferredSize());
        result.put("com.sun.jndi.ldap.connect.pool.timeout", SystemConnectionPoolProperties.getTimeoutInMillis());
        result.put("com.sun.jndi.ldap.connect.pool.protocol", this.getSupportedProtocol());
        result.put("com.sun.jndi.ldap.connect.pool.authentication", this.getSupportedAuthentication());
        return result;
    }

    private static String getTimeoutInMillis() {
        return System.getProperty("com.sun.jndi.ldap.connect.pool.timeout");
    }
}

