/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.impl;

import com.atlassian.crowd.embedded.api.ConnectionPoolProperties;
import com.atlassian.crowd.embedded.impl.ConnectionPoolPropertyConstants;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.math.NumberUtils;

public enum SystemConnectionPoolProperties implements ConnectionPoolProperties
{
    INSTANCE;


    public static ConnectionPoolProperties getInstance() {
        return INSTANCE;
    }

    @Override
    public String getInitialSize() {
        return System.getProperty("com.sun.jndi.ldap.connect.pool.initsize", "1");
    }

    @Override
    public String getMaximumSize() {
        return System.getProperty("com.sun.jndi.ldap.connect.pool.maxsize", "0");
    }

    @Override
    public String getPreferredSize() {
        return System.getProperty("com.sun.jndi.ldap.connect.pool.prefsize", "0");
    }

    @Override
    public String getSupportedProtocol() {
        return System.getProperty("com.sun.jndi.ldap.connect.pool.protocol", "plain ssl");
    }

    @Override
    public String getTimeoutInSec() {
        return Long.toString(TimeUnit.SECONDS.convert(NumberUtils.toLong((String)System.getProperty("com.sun.jndi.ldap.connect.pool.timeout", ConnectionPoolPropertyConstants.DEFAULT_POOL_TIMEOUT_MS)), TimeUnit.MILLISECONDS));
    }

    @Override
    public String getSupportedAuthentication() {
        return System.getProperty("com.sun.jndi.ldap.connect.pool.authentication", "simple");
    }

    @Override
    public Map<String, String> toPropertiesMap() {
        throw new UnsupportedOperationException("Should never reapply system property values.");
    }
}

