package com.atlassian.crowd.embedded.api;

import javax.annotation.Nullable;
import java.util.Collection;
import java.util.Optional;

/**
 * {@link Encryptor} which can be backed by more than one {@link Encryptor}.
 */
public interface SwitchableEncryptor extends Encryptor {

    /**
     * Switches the {@link Encryptor} to the one specified by <code>encryptorKey</code> or disable encryption when
     * <code>encryptorKey</code> is null.
     *
     * @param encryptorKey identifies one of the {@link Encryptor} or no encryption when null.
     * @throws IllegalArgumentException if provided <code>encryptorKey</code> is not available
     */
    void switchEncryptor(@Nullable String encryptorKey);

    /**
     * @return available encryptors' keys
     */
    Collection<String> getAvailableEncryptorKeys();

    /**
     * @return key of the currently used {@link Encryptor} or {@link Optional#empty()} when encryption is disabled
     */
    Optional<String> getCurrentEncryptorKey();
}
