/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.impl;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class IdentifierSet
extends ForwardingSet<String> {
    public static final IdentifierSet EMPTY = new IdentifierSet(ImmutableSet::of);
    private final Set<String> delegate;

    private IdentifierSet(Supplier<Set<String>> supplier) {
        this.delegate = supplier.get();
    }

    public IdentifierSet() {
        this.delegate = Sets.newHashSet();
    }

    public IdentifierSet(int expectedSize) {
        this.delegate = Sets.newHashSetWithExpectedSize((int)expectedSize);
    }

    public IdentifierSet(Collection<String> names) {
        this(names.size());
        this.addAll(names);
    }

    protected Set<String> delegate() {
        return this.delegate;
    }

    public boolean removeAll(Collection<?> collection) {
        return this.delegate().removeAll(IdentifierSet.lowercase(collection));
    }

    public boolean contains(Object object) {
        return this.delegate().contains(IdentifierSet.lowercase(object));
    }

    public boolean add(String element) {
        return this.delegate().add(IdentifierUtils.toLowerCase(element));
    }

    public boolean remove(Object object) {
        return this.delegate().remove(IdentifierSet.lowercase(object));
    }

    public boolean containsAll(Collection<?> collection) {
        return this.delegate().containsAll(IdentifierSet.lowercase(collection));
    }

    public boolean addAll(Collection<? extends String> strings) {
        return this.delegate().addAll(IdentifierSet.lowercaseStrings(strings));
    }

    public boolean retainAll(Collection<?> collection) {
        return this.delegate().retainAll(IdentifierSet.lowercase(collection));
    }

    public static IdentifierSet difference(Collection<String> set1, Collection<String> set2) {
        IdentifierSet result = new IdentifierSet(set1);
        result.removeAll(set2);
        return result;
    }

    public static IdentifierSet intersection(Collection<String> set1, Collection<String> set2) {
        IdentifierSet result = new IdentifierSet(set1);
        result.retainAll(set2);
        return result;
    }

    private static Object lowercase(Object element) {
        return element instanceof String ? IdentifierUtils.toLowerCase((String)element) : element;
    }

    private static Collection<?> lowercase(Collection<?> collection) {
        if (collection instanceof IdentifierSet) {
            return collection;
        }
        return collection.stream().map(IdentifierSet::lowercase).collect(Collectors.toSet());
    }

    private static Collection<? extends String> lowercaseStrings(Collection<? extends String> collection) {
        return collection instanceof IdentifierSet ? collection : IdentifierUtils.toLowerCase(collection);
    }
}

