/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.api;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nullable;

public class DirectorySynchronisationRoundInformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final long startTime;
    private final long durationMs;
    private final String statusKey;
    private final List<Serializable> statusParameters;
    private final String syncStatusToken;

    public DirectorySynchronisationRoundInformation(long startTime, long durationMs, @Nullable String statusKey, @Nullable List<Serializable> statusParameters, @Nullable String syncStatusToken) {
        this.startTime = startTime;
        this.durationMs = durationMs;
        this.statusKey = statusKey;
        this.statusParameters = statusParameters == null ? null : ImmutableList.copyOf(statusParameters);
        this.syncStatusToken = Strings.nullToEmpty((String)syncStatusToken);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getDurationMs() {
        return this.durationMs;
    }

    @Nullable
    public String getStatusKey() {
        return this.statusKey;
    }

    @Nullable
    public List<Serializable> getStatusParameters() {
        return this.statusParameters;
    }

    public String getSyncStatusToken() {
        return this.syncStatusToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DirectorySynchronisationRoundInformation that = (DirectorySynchronisationRoundInformation)o;
        return this.startTime == that.startTime && this.durationMs == that.durationMs && Objects.equal((Object)this.statusKey, (Object)that.statusKey) && Objects.equal(this.statusParameters, that.statusParameters) && Objects.equal((Object)this.syncStatusToken, (Object)that.syncStatusToken);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.startTime, this.durationMs, this.statusKey, this.statusParameters, this.syncStatusToken});
    }
}

