/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.support;

import com.atlassian.crowd.embedded.admin.util.HtmlEncoder;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.support.SupportInformationService;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;

public final class SupportController {
    private final HtmlEncoder htmlEncoder;
    private final SupportInformationService supportInformationService;
    private final CrowdService crowdService;

    public SupportController(HtmlEncoder htmlEncoder, SupportInformationService supportInformationService, CrowdService crowdService) {
        this.htmlEncoder = htmlEncoder;
        this.supportInformationService = supportInformationService;
        this.crowdService = crowdService;
    }

    public ModelAndView directories(HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        User user = this.crowdService.getUser(request.getRemoteUser());
        model.put("supportInformation", this.supportInformationService.getSupportInformation(user));
        model.put("context", model);
        model.put("req", request);
        model.put("htmlEncoder", this.htmlEncoder);
        return new ModelAndView("support-directories", model);
    }

    public void download(HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = this.crowdService.getUser(request.getRemoteUser());
        response.setContentType("text/plain; charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=atlassian-directory-configuration.txt");
        response.getWriter().println(this.supportInformationService.getSupportInformation(user));
        response.getWriter().flush();
    }
}

