/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.crowd;

import com.atlassian.crowd.embedded.admin.crowd.CrowdDirectoryConfiguration;
import org.apache.commons.lang.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public final class CrowdDirectoryConfigurationValidator
implements Validator {
    public boolean supports(Class clazz) {
        return CrowdDirectoryConfiguration.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        CrowdDirectoryConfiguration configuration = (CrowdDirectoryConfiguration)target;
        if (configuration.getCrowdServerSynchroniseIntervalInMin() < 1L) {
            errors.rejectValue("crowdServerSynchroniseIntervalInMin", "invalid");
        }
        if (StringUtils.isEmpty((String)configuration.getPassword()) && this.isCreatingNewDirectory(configuration)) {
            errors.rejectValue("applicationPassword", "required");
        }
    }

    private boolean isCreatingNewDirectory(CrowdDirectoryConfiguration configuration) {
        return configuration.getDirectoryId() == 0L;
    }
}

