/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.xwork.interceptors;

import com.atlassian.crowd.xwork.RequireSecurityToken;
import com.atlassian.crowd.xwork.SimpleXsrfTokenGenerator;
import com.atlassian.crowd.xwork.XWorkVersionSupport;
import com.atlassian.crowd.xwork.XsrfTokenGenerator;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.xwork.Action;
import com.opensymphony.xwork.ActionInvocation;
import com.opensymphony.xwork.ValidationAware;
import com.opensymphony.xwork.interceptor.Interceptor;
import java.lang.reflect.Method;

public class XsrfTokenInterceptor
implements Interceptor {
    public static final String REQUEST_PARAM_NAME = "atl_token";
    public static final String CONFIG_PARAM_NAME = "RequireSecurityToken";
    public static final String VALIDATION_FAILED_ERROR_KEY = "atlassian.xwork.xsrf.badtoken";
    public static final String SECURITY_TOKEN_REQUIRED_ERROR_KEY = "atlassian.xwork.xsrf.notoken";
    public static final String OVERRIDE_HEADER_NAME = "X-Atlassian-Token";
    public static final String OVERRIDE_HEADER_VALUE = "no-check";
    private final XsrfTokenGenerator tokenGenerator;
    private final XWorkVersionSupport versionSupport = new XWorkVersionSupport();

    public XsrfTokenInterceptor() {
        this(new SimpleXsrfTokenGenerator());
    }

    public XsrfTokenInterceptor(XsrfTokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }

    public String intercept(ActionInvocation invocation) throws Exception {
        Method invocationMethod = this.versionSupport.extractMethod(invocation);
        String configParam = (String)invocation.getProxy().getConfig().getParams().get(CONFIG_PARAM_NAME);
        RequireSecurityToken annotation = invocationMethod.getAnnotation(RequireSecurityToken.class);
        boolean isProtected = this.methodRequiresProtection(configParam, annotation);
        String token = ServletActionContext.getRequest().getParameter(REQUEST_PARAM_NAME);
        boolean validToken = this.tokenGenerator.validateToken(ServletActionContext.getRequest(), token);
        if (isProtected && !validToken) {
            if (token == null) {
                this.addInvalidTokenError(this.versionSupport.extractAction(invocation), SECURITY_TOKEN_REQUIRED_ERROR_KEY);
            } else {
                this.addInvalidTokenError(this.versionSupport.extractAction(invocation), VALIDATION_FAILED_ERROR_KEY);
            }
            ServletActionContext.getResponse().setStatus(403);
            return "input";
        }
        return invocation.invoke();
    }

    private boolean methodRequiresProtection(String configParam, RequireSecurityToken annotation) {
        if (this.isOverrideHeaderPresent()) {
            return false;
        }
        if (configParam != null) {
            return Boolean.valueOf(configParam);
        }
        if (annotation != null) {
            return annotation.value();
        }
        return this.getSecurityLevel().getDefaultProtection();
    }

    protected void addInvalidTokenError(Action action, String errorMessageKey) {
        if (action instanceof ValidationAware) {
            ((ValidationAware)action).addActionError(this.internationaliseErrorMessage(action, errorMessageKey));
        }
    }

    protected String internationaliseErrorMessage(Action action, String messageKey) {
        return messageKey;
    }

    private boolean isOverrideHeaderPresent() {
        return OVERRIDE_HEADER_VALUE.equals(ServletActionContext.getRequest().getHeader(OVERRIDE_HEADER_NAME));
    }

    public void destroy() {
    }

    public void init() {
    }

    protected SecurityLevel getSecurityLevel() {
        return SecurityLevel.OPT_IN;
    }

    public static enum SecurityLevel {
        OPT_IN(false),
        OPT_OUT(true);

        private final boolean defaultProtection;

        private SecurityLevel(boolean defaultProtection) {
            this.defaultProtection = defaultProtection;
        }

        public boolean getDefaultProtection() {
            return this.defaultProtection;
        }
    }
}

