/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class UpgradeTask322
implements UpgradeTask {
    private DirectoryManager directoryManager;

    public String getBuildNumber() {
        return "322";
    }

    public String getShortDescription() {
        return "Adding 'displayName' attribute mapping to non-internal directories";
    }

    public void doUpgrade() throws Exception {
        List directories = this.directoryManager.searchDirectories(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
        for (Directory directory : directories) {
            if (directory.getType() == DirectoryType.INTERNAL) continue;
            directory.setAttribute("ldap.user.displayname", "displayName");
            this.directoryManager.updateDirectory(directory);
        }
    }

    public Collection getErrors() {
        return Collections.EMPTY_LIST;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

