/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpgradeTask216
implements UpgradeTask {
    private Collection errors = new ArrayList();
    private DirectoryManager directoryManager;

    public String getBuildNumber() {
        return "216";
    }

    public String getShortDescription() {
        return "Adding an ldap.user.username.rdn to directories that lack it. Will be set the same as ldap.user.username except for Active Directory.";
    }

    public void doUpgrade() throws Exception {
        List directories = this.directoryManager.searchDirectories(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
        for (Directory directory : directories) {
            if (directory.getAttribute("ldap.user.username.rdn") != null) continue;
            String rdnValue = "com.atlassian.crowd.integration.directory.connector.MicrosoftActiveDirectory".equals(directory.getImplementationClass()) ? "cn" : directory.getAttribute("ldap.user.username");
            directory.setAttribute("ldap.user.username.rdn", rdnValue);
            this.directoryManager.updateDirectory(directory);
        }
    }

    public Collection getErrors() {
        return this.errors;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

