/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.integration.directory.connector.OpenLDAP;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpgradeTask214
implements UpgradeTask {
    private Collection errors = new ArrayList();
    private DirectoryManager directoryManager;

    public String getBuildNumber() {
        return "214";
    }

    public String getShortDescription() {
        return "Removing superfluous encryption attribute(ldap.user.encryption) from directories that don't use encryption types.";
    }

    public void doUpgrade() throws Exception {
        List directories = this.directoryManager.searchDirectories(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.directory()).returningAtMost(-1));
        for (Directory directory : directories) {
            if (OpenLDAP.class.getCanonicalName().equals(directory.getImplementationClass())) continue;
            directory.removeAttribute("ldap.user.encryption");
            this.directoryManager.updateDirectory(directory);
        }
    }

    public Collection getErrors() {
        return this.errors;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

