/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.directory.Directory;
import com.atlassian.crowd.model.directory.DirectoryType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.SearchRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.dao.DataAccessException;

public class UpgradeTask113
implements UpgradeTask {
    private DirectoryManager directoryManager;
    private List errors = new ArrayList();

    public String getBuildNumber() {
        return "113";
    }

    public String getShortDescription() {
        return "Set encryption method for all current Internal Directories to be DES";
    }

    public void doUpgrade() throws Exception {
        List directories = this.directoryManager.searchDirectories(QueryBuilder.queryFor((EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.INTERNAL)).returningAtMost(-1));
        for (Directory directory : directories) {
            String userEncryption = directory.getAttribute("user_encryption_method");
            if (userEncryption != null) continue;
            directory.setAttribute("user_encryption_method", "des");
            try {
                this.directoryManager.updateDirectory(directory);
            }
            catch (DataAccessException e) {
                this.errors.add(e.getMessage());
                throw e;
            }
        }
    }

    public Collection getErrors() {
        return this.errors;
    }

    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }
}

