/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.test.util;

import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;

public class SettableClock
extends Clock {
    Instant timestamp;

    public SettableClock() {
        this(LocalDateTime.of(1999, 12, 31, 23, 58).toInstant(ZoneOffset.UTC));
    }

    public SettableClock(long epochMilli) {
        this(Instant.ofEpochMilli(epochMilli));
    }

    public SettableClock(Instant timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public ZoneId getZone() {
        return ZoneOffset.UTC;
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return new SettableClock();
    }

    @Override
    public Instant instant() {
        return this.timestamp;
    }

    public void addMillis(long millis) {
        this.timestamp = this.timestamp.plusMillis(millis);
    }

    public void setEpochMillis(long epochMilli) {
        this.timestamp = Instant.ofEpochMilli(epochMilli);
    }
}

