/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.test.util;

import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserWithAttributes;
import org.junit.Assert;

public final class ModelAssertions {
    private ModelAssertions() {
    }

    public static void assertUsersEqual(User expected, User actual) {
        Assert.assertEquals((String)"directory IDs should be the same", (long)expected.getDirectoryId(), (long)actual.getDirectoryId());
        Assert.assertEquals((String)"usernames should be the same", (Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((String)"first names should be the same", (Object)expected.getFirstName(), (Object)actual.getFirstName());
        Assert.assertEquals((String)"last names should be the same", (Object)expected.getLastName(), (Object)actual.getLastName());
        Assert.assertEquals((String)"display names should be the same", (Object)expected.getDisplayName(), (Object)actual.getDisplayName());
        Assert.assertEquals((String)"email addresses should be the same", (Object)expected.getEmailAddress(), (Object)actual.getEmailAddress());
    }

    public static void assertUsersWithAttributesEqual(UserWithAttributes expected, UserWithAttributes actual) {
        ModelAssertions.assertUsersEqual((User)expected, (User)actual);
        ModelAssertions.assertAttributesEqual(expected, actual);
    }

    public static void assertGroupsEqual(Group expected, Group actual) {
        Assert.assertEquals((String)"directory IDs should be the same", (long)expected.getDirectoryId(), (long)actual.getDirectoryId());
        Assert.assertEquals((String)"group names should be the same", (Object)expected.getName(), (Object)actual.getName());
        Assert.assertEquals((String)"group types should be the same", (Object)expected.getType(), (Object)actual.getType());
    }

    private static void assertAttributesEqual(UserWithAttributes expected, UserWithAttributes actual) {
        Assert.assertEquals((String)"the attribute keys should be the same", (Object)actual.getKeys(), (Object)expected.getKeys());
        for (String key : expected.getKeys()) {
            Assert.assertEquals((String)"the attribute values should be the same", (Object)actual.getValues(key), (Object)expected.getValues(key));
        }
    }
}

