package com.atlassian.crowd.util;

import org.apache.commons.lang3.StringUtils;

public final class EqualityUtil {

    private EqualityUtil() {}

    /**
     * Returns true if the two input Strings are different values, where null and empty String are considered equal.
     * <p>
     * The {@code remoteString} argument is filtered through {@link InternalEntityUtils#truncateValue(String)}
     * before comparison.
     *
     * @param remoteString   remote directory value
     * @param internalString internal directory value
     * @return true if the two input Strings are different values.
     */
    public static boolean different(final String remoteString, final String internalString) {
        // Treat null and empty string as equivalent
        if (StringUtils.isEmpty(remoteString)) {
            return StringUtils.isNotEmpty(internalString);
        }
        return !InternalEntityUtils.truncateValue(remoteString).equals(internalString);
    }
}
