/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration.legacy.database;

import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.legacy.LegacyImportDataHolder;
import com.atlassian.crowd.migration.legacy.database.DatabaseImporter;
import com.atlassian.crowd.migration.legacy.database.DatabaseMapper;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchResultWithIdReferences;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SessionFactory;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserMapper
extends DatabaseMapper
implements DatabaseImporter {
    private final DirectoryDAOHibernate directoryDAO;
    private final UserDAOHibernate userDAO;

    public UserMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, JdbcOperations jdbcTemplate, UserDAOHibernate userDAO, DirectoryDAOHibernate directoryDAO) {
        super(sessionFactory, batchProcessor, jdbcTemplate);
        this.directoryDAO = directoryDAO;
        this.userDAO = userDAO;
    }

    @Override
    public void importFromDatabase(LegacyImportDataHolder importData) throws ImportException {
        List<UserTemplateWithCredentialAndAttributes> users = this.importUsersFromDatabase(importData.getOldToNewDirectoryIds());
        BatchResultWithIdReferences result = this.userDAO.addAll(users);
        for (User user : result.getFailedEntities()) {
            this.logger.error((Object)("Unable to add user <" + user.getName() + "> in directory with id <" + user.getDirectoryId() + ">"));
        }
        if (result.hasFailures()) {
            throw new ImportException("Unable to import all users. See logs for more details.");
        }
        importData.setUserImportResults((BatchResultWithIdReferences<User>)result);
        this.logger.info((Object)("Successfully migrated " + users.size() + " users."));
    }

    protected List<UserTemplateWithCredentialAndAttributes> importUsersFromDatabase(Map<Long, Long> oldToNewDirectoryIds) throws ImportException {
        ArrayList<UserTemplateWithCredentialAndAttributes> users = new ArrayList<UserTemplateWithCredentialAndAttributes>();
        List<InternalEntityTemplate> entityTemplates = this.getInternalEntityTemplatesForUsers();
        Map<DatabaseMapper.EntityIdentifier, Map<String, Set<String>>> allUserAttributes = this.getAllUserAttributes();
        Map<DatabaseMapper.EntityIdentifier, PasswordCredential> allUserCredentials = this.getCredentials();
        Map<DatabaseMapper.EntityIdentifier, List<PasswordCredential>> allUserCredentialsHistory = this.getCredentialsHistory();
        for (InternalEntityTemplate entityTemplate : entityTemplates) {
            String userName = entityTemplate.getName();
            Date createdDate = entityTemplate.getCreatedDate();
            Date updatedDate = entityTemplate.getUpdatedDate();
            boolean active = entityTemplate.isActive();
            Long oldDirectoryId = entityTemplate.getId();
            Long directoryId = oldToNewDirectoryIds.get(oldDirectoryId);
            DatabaseMapper.EntityIdentifier currentUser = new DatabaseMapper.EntityIdentifier(oldDirectoryId, userName);
            entityTemplate.setId(null);
            if (directoryId == null) {
                throw new IllegalArgumentException("User belongs to an unknown old directory with ID: " + oldDirectoryId);
            }
            Directory directory = (Directory)this.directoryDAO.loadReference(directoryId.longValue());
            Map<String, Set<String>> attributes = allUserAttributes.get(currentUser);
            String firstName = this.getAttributeValue("givenName", attributes, "");
            String lastName = this.getAttributeValue("sn", attributes, "");
            String displayName = this.getAttributeValue("displayName", attributes, "");
            String email = this.getAttributeValue("mail", attributes, "");
            PasswordCredential credential = allUserCredentials.get(currentUser);
            if (credential == null) {
                credential = PasswordCredential.NONE;
            }
            UserTemplateWithCredentialAndAttributes userTemplate = new UserTemplateWithCredentialAndAttributes(userName, directoryId.longValue(), credential);
            userTemplate.setCreatedDate(createdDate);
            userTemplate.setUpdatedDate(updatedDate);
            userTemplate.setActive(active);
            userTemplate.setFirstName(firstName);
            userTemplate.setLastName(lastName);
            userTemplate.setDisplayName(displayName);
            userTemplate.setEmailAddress(email);
            List<PasswordCredential> records = allUserCredentialsHistory.get(currentUser);
            if (records == null) {
                records = new ArrayList<PasswordCredential>();
            }
            userTemplate.getCredentialHistory().addAll(records);
            attributes.remove("givenName");
            attributes.remove("sn");
            attributes.remove("displayName");
            attributes.remove("mail");
            userTemplate.getAttributes().putAll(attributes);
            users.add(userTemplate);
        }
        return users;
    }

    private List<InternalEntityTemplate> getInternalEntityTemplatesForUsers() {
        return this.jdbcTemplate.query(this.legacyTableQueries.getInternalEntityTemplatesForUsersSQL(), (RowMapper)new UserTableMapper());
    }

    private Map<DatabaseMapper.EntityIdentifier, PasswordCredential> getCredentials() {
        UserCredentialMapper userCredentialMapper = new UserCredentialMapper();
        this.jdbcTemplate.query(this.legacyTableQueries.getUserCredentialsSQL(), (RowCallbackHandler)userCredentialMapper);
        return userCredentialMapper.getUserCredential();
    }

    private Map<DatabaseMapper.EntityIdentifier, Map<String, Set<String>>> getAllUserAttributes() {
        DatabaseMapper.AttributeMapper userAttributeMapper = new DatabaseMapper.AttributeMapper("REMOTEPRINCIPALDIRECTORYID", "REMOTEPRINCIPALNAME");
        this.jdbcTemplate.query(this.legacyTableQueries.getAllUserAttributesSQL(), (RowCallbackHandler)userAttributeMapper);
        Map<DatabaseMapper.EntityIdentifier, List<Map<String, String>>> userAttributes = userAttributeMapper.getEntityAttributes();
        HashMap<DatabaseMapper.EntityIdentifier, Map<String, Set<String>>> userAttributeMap = new HashMap<DatabaseMapper.EntityIdentifier, Map<String, Set<String>>>();
        for (Map.Entry<DatabaseMapper.EntityIdentifier, List<Map<String, String>>> entry : userAttributes.entrySet()) {
            userAttributeMap.put(entry.getKey(), this.attributeListToMultiAttributeMap(entry.getValue()));
        }
        return userAttributeMap;
    }

    private Map<DatabaseMapper.EntityIdentifier, List<PasswordCredential>> getCredentialsHistory() {
        UserCredentialMapper userCredentialMapper = new UserCredentialMapper();
        this.jdbcTemplate.query(this.legacyTableQueries.getUserCredentialsHistorySQL(), (RowCallbackHandler)userCredentialMapper);
        return userCredentialMapper.getUserCredentialHistory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UserCredentialMapper
    implements RowCallbackHandler {
        private final Map<DatabaseMapper.EntityIdentifier, PasswordCredential> userCredential = new HashMap<DatabaseMapper.EntityIdentifier, PasswordCredential>();
        private final Map<DatabaseMapper.EntityIdentifier, List<PasswordCredential>> userCredentialHistory = new HashMap<DatabaseMapper.EntityIdentifier, List<PasswordCredential>>();

        private UserCredentialMapper() {
        }

        public void processRow(ResultSet rs) throws SQLException {
            String credential = rs.getString("CREDENTIAL");
            String username = rs.getString("REMOTEPRINCIPALNAME");
            Long directoryId = rs.getLong("REMOTEPRINCIPALDIRECTORYID");
            DatabaseMapper.EntityIdentifier currentUser = new DatabaseMapper.EntityIdentifier(directoryId, username);
            if (StringUtils.isBlank((String)credential)) {
                credential = "password";
            }
            PasswordCredential passwordCredential = new PasswordCredential(credential, true);
            this.userCredential.put(currentUser, passwordCredential);
            if (!this.userCredentialHistory.containsKey(currentUser)) {
                this.userCredentialHistory.put(currentUser, new ArrayList());
            }
            this.userCredentialHistory.get(currentUser).add(passwordCredential);
        }

        public Map<DatabaseMapper.EntityIdentifier, PasswordCredential> getUserCredential() {
            return this.userCredential;
        }

        public Map<DatabaseMapper.EntityIdentifier, List<PasswordCredential>> getUserCredentialHistory() {
            return this.userCredentialHistory;
        }
    }

    private class UserTableMapper
    implements RowMapper {
        private UserTableMapper() {
        }

        public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
            Long oldDirectoryId = rs.getLong("DIRECTORYID");
            String userName = rs.getString("NAME");
            Date createDate = UserMapper.this.getDateFromDatabase(rs.getString("CONCEPTION"));
            Date updatedDate = UserMapper.this.getDateFromDatabase(rs.getString("LASTMODIFIED"));
            boolean active = rs.getBoolean("ACTIVE");
            return UserMapper.this.createInternalEntityTemplate(oldDirectoryId, userName, createDate, updatedDate, active);
        }
    }
}

