/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration;

import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.migration.ExportException;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.Mapper;
import com.atlassian.crowd.migration.legacy.XmlMapper;
import com.atlassian.crowd.model.InternalEntity;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.InternalUserAttribute;
import com.atlassian.crowd.model.user.InternalUserCredentialRecord;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserMapper
extends XmlMapper
implements Mapper {
    private final UserDAOHibernate userDAO;
    private final DirectoryDAOHibernate directoryDAO;
    protected static final String USER_XML_ROOT = "users";
    protected static final String USER_XML_NODE = "user";
    private static final String USER_XML_DIRECTORY_ID = "directoryId";
    private static final String USER_XML_FIRST_NAME = "firstName";
    private static final String USER_XML_LAST_NAME = "lastName";
    private static final String USER_XML_DISPLAY_NAME = "displayName";
    private static final String USER_XML_EMAIL = "email";
    private static final String USER_XML_CREDENTIAL = "credential";
    private static final String USER_XML_CREDENTIAL_RECORDS = "credentialRecords";
    private static final String USER_XML_CREDENTIAL_RECORD = "credentialRecord";
    private static final String USER_XML_ATTRIBUTES = "attributes";
    private static final String USER_XML_ATTRIBUTE = "attribute";
    private static final String USER_XML_ATTRIBUTE_NAME = "name";
    private static final String USER_XML_ATTRIBUTE_VALUE = "value";

    public UserMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, DirectoryDAOHibernate directoryDAO, UserDAOHibernate userDAO) {
        super(sessionFactory, batchProcessor);
        this.directoryDAO = directoryDAO;
        this.userDAO = userDAO;
    }

    @Override
    public Element exportXml(Map options) throws ExportException {
        Element userRoot = DocumentHelper.createElement((String)USER_XML_ROOT);
        List<Directory> directories = this.findAllExportableDirectories();
        for (Directory directory : directories) {
            List users = this.userDAO.search(directory.getId().longValue(), QueryBuilder.queryFor(InternalUser.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
            for (InternalUser user : users) {
                Set attributes = this.userDAO.findUserAttributes(user.getId().longValue());
                this.addUserToXml(user, attributes, userRoot);
            }
        }
        return userRoot;
    }

    protected void addUserToXml(InternalUser user, Collection<InternalUserAttribute> attributes, Element userRoot) {
        Element userElement = userRoot.addElement(USER_XML_NODE);
        userElement.addElement(USER_XML_DIRECTORY_ID).addText(String.valueOf(user.getDirectoryId()));
        this.exportInternalEntity((InternalEntity)user, userElement);
        userElement.addElement(USER_XML_FIRST_NAME).addText(user.getFirstName());
        userElement.addElement(USER_XML_LAST_NAME).addText(user.getLastName());
        userElement.addElement(USER_XML_DISPLAY_NAME).addText(user.getDisplayName());
        userElement.addElement(USER_XML_EMAIL).addText(user.getEmailAddress());
        userElement.addElement(USER_XML_CREDENTIAL).addText(user.getCredential().getCredential());
        this.addUserCredentialRecordsToXml(user.getCredentialRecords(), userElement);
        this.addUserAttributesToXml(attributes, userElement);
    }

    private void addUserCredentialRecordsToXml(List<InternalUserCredentialRecord> records, Element userElement) {
        Element credentialRecordsElement = userElement.addElement(USER_XML_CREDENTIAL_RECORDS);
        for (InternalUserCredentialRecord record : records) {
            Element recordElement = credentialRecordsElement.addElement(USER_XML_CREDENTIAL_RECORD);
            recordElement.addElement("id").addText(record.getId().toString());
            recordElement.addElement(USER_XML_CREDENTIAL).addText(record.getPasswordHash());
        }
    }

    private void addUserAttributesToXml(Collection<InternalUserAttribute> attributes, Element userElement) {
        Element attributesElement = userElement.addElement(USER_XML_ATTRIBUTES);
        for (InternalUserAttribute attribute : attributes) {
            Element attributeElement = attributesElement.addElement(USER_XML_ATTRIBUTE);
            attributeElement.addElement("id").addText(attribute.getId().toString());
            attributeElement.addElement(USER_XML_ATTRIBUTE_NAME).addText(attribute.getName());
            attributeElement.addElement(USER_XML_ATTRIBUTE_VALUE).addText(attribute.getValue());
        }
    }

    @Override
    public void importXml(Element root) throws ImportException {
        Element usersElement = (Element)root.selectSingleNode("/crowd/ users");
        if (usersElement == null) {
            this.logger.error((Object)"No users were found for importing!");
            return;
        }
        ArrayList<InternalUser> usersToReplicate = new ArrayList<InternalUser>();
        ArrayList<InternalUserAttribute> userAttributesToReplicate = new ArrayList<InternalUserAttribute>();
        Iterator userElementIterator = usersElement.elementIterator();
        while (userElementIterator.hasNext()) {
            Element userElement = (Element)userElementIterator.next();
            InternalUser user = this.getUserFromXml(userElement);
            if (FULL_BACKUP_DIRECTORY_TYPES.contains(user.getDirectory().getType())) {
                usersToReplicate.add(user);
            }
            List<InternalUserAttribute> attributes = this.getUserAttributesFromXml(userElement, user);
            userAttributesToReplicate.addAll(attributes);
        }
        this.logger.info((Object)("About to replicate " + usersToReplicate.size() + " users"));
        this.addEntities(usersToReplicate);
        this.logger.info((Object)"User replication complete");
        this.logger.info((Object)("About to replicate " + userAttributesToReplicate.size() + " user attributes"));
        this.addEntities(userAttributesToReplicate);
        this.logger.info((Object)"User attribute replication complete");
    }

    protected InternalUser getUserFromXml(Element userElement) {
        Long directoryId = Long.parseLong(userElement.element(USER_XML_DIRECTORY_ID).getText());
        DirectoryImpl directory = (DirectoryImpl)this.directoryDAO.loadReference(directoryId.longValue());
        InternalEntityTemplate internalEntityTemplate = this.getInternalEntityTemplateFromXml(userElement);
        UserTemplate userTemplate = new UserTemplate(internalEntityTemplate.getName(), directoryId.longValue());
        userTemplate.setActive(internalEntityTemplate.isActive());
        userTemplate.setFirstName(userElement.element(USER_XML_FIRST_NAME).getText());
        userTemplate.setLastName(userElement.element(USER_XML_LAST_NAME).getText());
        userTemplate.setDisplayName(userElement.element(USER_XML_DISPLAY_NAME).getText());
        userTemplate.setEmailAddress(userElement.element(USER_XML_EMAIL).getText());
        PasswordCredential credential = new PasswordCredential(userElement.element(USER_XML_CREDENTIAL).getText(), true);
        InternalUser user = new InternalUser(internalEntityTemplate, (Directory)directory, userTemplate, credential);
        List<InternalUserCredentialRecord> records = this.getUserCredentialRecordsFromXml(userElement, user);
        user.getCredentialRecords().addAll(records);
        return user;
    }

    private List<InternalUserCredentialRecord> getUserCredentialRecordsFromXml(Element userElement, InternalUser userReference) {
        ArrayList<InternalUserCredentialRecord> records = new ArrayList<InternalUserCredentialRecord>();
        Element credentialRecordsElement = userElement.element(USER_XML_CREDENTIAL_RECORDS);
        Iterator recordsIter = credentialRecordsElement.elementIterator();
        while (recordsIter.hasNext()) {
            Element recordElement = (Element)recordsIter.next();
            Long id = Long.parseLong(recordElement.element("id").getText());
            String password = recordElement.element(USER_XML_CREDENTIAL).getText();
            InternalUserCredentialRecord record = new InternalUserCredentialRecord(id, userReference, password);
            records.add(record);
        }
        return records;
    }

    protected List<InternalUserAttribute> getUserAttributesFromXml(Element userElement, InternalUser userReference) {
        ArrayList<InternalUserAttribute> attributes = new ArrayList<InternalUserAttribute>();
        Element attributesElement = userElement.element(USER_XML_ATTRIBUTES);
        Iterator attribsIterator = attributesElement.elementIterator();
        while (attribsIterator.hasNext()) {
            Element attributeElement = (Element)attribsIterator.next();
            Long id = Long.parseLong(attributeElement.element("id").getText());
            String name = attributeElement.element(USER_XML_ATTRIBUTE_NAME).getText();
            String value = attributeElement.element(USER_XML_ATTRIBUTE_VALUE).getText();
            InternalUserAttribute attribute = new InternalUserAttribute(id, userReference, name, value);
            attributes.add(attribute);
        }
        return attributes;
    }
}

