/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.migration;

import com.atlassian.crowd.dao.property.PropertyDAO;
import com.atlassian.crowd.migration.ExportException;
import com.atlassian.crowd.migration.ImportException;
import com.atlassian.crowd.migration.Mapper;
import com.atlassian.crowd.migration.legacy.XmlMapper;
import com.atlassian.crowd.model.property.Property;
import com.atlassian.crowd.util.persistence.hibernate.batch.BatchProcessor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.hibernate.SessionFactory;

public class PropertyMapper
extends XmlMapper
implements Mapper {
    private final PropertyDAO propertyDAO;
    protected static final String PROPERTIES_XML_ROOT = "properties";
    protected static final String PROPERTY_XML_NODE = "property";
    protected static final String PROPERTY_XML_KEY = "key";
    protected static final String PROPERTY_XML_NAME = "name";
    protected static final String PROPERTY_XML_VALUE = "value";

    public PropertyMapper(SessionFactory sessionFactory, BatchProcessor batchProcessor, PropertyDAO propertyDAO) {
        super(sessionFactory, batchProcessor);
        this.propertyDAO = propertyDAO;
    }

    public Element exportXml(Map options) throws ExportException {
        Element propertiesRoot = DocumentHelper.createElement((String)PROPERTIES_XML_ROOT);
        List properties = this.propertyDAO.findAll();
        Boolean resetDomainOption = options.containsKey("OPTION_RESET_DOMAIN") ? (Boolean)options.get("OPTION_RESET_DOMAIN") : Boolean.FALSE;
        if (properties != null && !properties.isEmpty()) {
            for (Property property : properties) {
                Element propertyElement = propertiesRoot.addElement(PROPERTY_XML_NODE);
                propertyElement.addElement(PROPERTY_XML_KEY).addText(property.getKey());
                propertyElement.addElement(PROPERTY_XML_NAME).addText(property.getName());
                if ("crowd".equals(property.getKey()) && "domain".equals(property.getName()) && resetDomainOption.booleanValue()) {
                    propertyElement.addElement(PROPERTY_XML_VALUE).addText("");
                    continue;
                }
                propertyElement.addElement(PROPERTY_XML_VALUE).addText(property.getValue() != null ? property.getValue() : "");
            }
        } else {
            this.logger.error((Object)"Failed to find any properties to export!");
        }
        return propertiesRoot;
    }

    public void importXml(Element root) throws ImportException {
        this.importProperties(root);
    }

    private void importProperties(Element root) {
        Element propertiesElement = (Element)root.selectSingleNode("/crowd/ properties");
        if (propertiesElement == null) {
            this.logger.error((Object)"No properties were found for importing!");
        } else {
            Iterator properties = propertiesElement.elementIterator();
            while (properties.hasNext()) {
                Element propertyElemet = (Element)properties.next();
                Element propertyKeyElement = propertyElemet.element(PROPERTY_XML_KEY);
                String key = propertyKeyElement != null && propertyKeyElement.getText() != null ? propertyKeyElement.getText() : "crowd";
                String name = propertyElemet.element(PROPERTY_XML_NAME).getText();
                String value = propertyElemet.element(PROPERTY_XML_VALUE).getText();
                this.propertyDAO.add(new Property(key, name, value));
            }
        }
    }
}

