package com.atlassian.crowd.manager.cluster.message;

import java.util.Objects;

import com.atlassian.crowd.service.cluster.ClusterMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleClusterMessageListener implements ClusterMessageListener {
    private static final Logger log = LoggerFactory.getLogger(SingleClusterMessageListener.class);

    private final String channel;
    private final String message;

    private final Runnable callback;

    public SingleClusterMessageListener(final String channel, final String message, Runnable callback) {
        this.channel = channel;
        this.message = message;
        this.callback = callback;
    }

    @Override
    public void handleMessage(String channel, String message) {
        if (Objects.equals(this.channel, channel) && Objects.equals(this.message, message)) {
            callback.run();
        } else {
            log.warn("Received unknown cluster message {} on channel {}, ignoring", message, channel);
        }
    }

    public String getChannel() {
        return channel;
    }

    public String getMessage() {
        return message;
    }
}