package com.atlassian.crowd.audit;

import com.atlassian.annotations.Internal;

import java.util.Optional;

/**
 * Internal extension of {@link AuditLogContext} that allows to obtain the current state in the context
 * @since 3.2.0
 */
@Internal
public interface AuditLogContextInternal extends AuditLogContext {

    /**
     * @return the author currently stored in the context
     */
    Optional<AuditLogAuthor> getAuthor();

    /**
     * @return the event source
     */
    Optional<AuditLogEventSource> getSource();
}
