/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.util;

import com.atlassian.crowd.manager.cache.CacheManager;
import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.atlassian.crowd.model.application.Application;
import java.io.Serializable;
import java.net.InetAddress;

public class InetAddressCacheUtil {
    public static final String INET_ADDRESS_CACHE_NAME = InetAddressCacheUtil.class.getName() + "_cache";
    private final CacheManager cacheManager;

    public InetAddressCacheUtil(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void setPermitted(Application application, InetAddress address, boolean permitted) {
        String key = InetAddressCacheUtil.getKeyName(application, address);
        this.cacheManager.put(INET_ADDRESS_CACHE_NAME, (Serializable)((Object)key), (Serializable)Boolean.valueOf(permitted));
    }

    public boolean getPermitted(Application application, InetAddress address) throws NotInCacheException {
        String key = InetAddressCacheUtil.getKeyName(application, address);
        Boolean permitted = (Boolean)this.cacheManager.get(INET_ADDRESS_CACHE_NAME, (Serializable)((Object)key));
        return permitted != null && permitted != false;
    }

    public void clearCache() {
        this.cacheManager.removeAll(INET_ADDRESS_CACHE_NAME);
    }

    private static String getKeyName(Application application, InetAddress address) {
        return application.getName() + "#" + address.getHostAddress();
    }
}

