/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.validation;

import com.atlassian.crowd.manager.proxy.TrustedProxyManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;

public class XForwardedForUtil {
    private static final String X_FORWARDED_FOR = "X-Forwarded-For";

    private XForwardedForUtil() {
    }

    public static InetAddress getTrustedAddress(TrustedProxyManager trustedProxyManager, HttpServletRequest request) {
        String trustedAddress = XForwardedForUtil.getTrustedAddress(trustedProxyManager, request.getRemoteAddr(), request.getHeader(X_FORWARDED_FOR));
        try {
            return InetAddress.getByName(trustedAddress);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getTrustedAddress(TrustedProxyManager trustedProxyManager, String requestAddress, String xForwardedFor) {
        RequestAddressInfo holder = XForwardedForUtil.getRequestAddressInfo(requestAddress, xForwardedFor);
        if (!holder.getProxies().isEmpty()) {
            for (String proxy : holder.getProxies()) {
                if (trustedProxyManager.isTrusted(proxy)) continue;
                return holder.getRequestAddress();
            }
            return holder.getClientAddress();
        }
        return holder.getClientAddress();
    }

    private static RequestAddressInfo getRequestAddressInfo(String requestAddress, String xForwardedFor) {
        String clientAddress = requestAddress;
        ArrayList proxies = Lists.newArrayList();
        if (StringUtils.isNotBlank((String)xForwardedFor)) {
            proxies.addAll(Arrays.asList(StringUtils.split((String)xForwardedFor, (String)", ")));
            proxies.add(requestAddress);
            clientAddress = (String)proxies.remove(0);
        }
        return new RequestAddressInfo(requestAddress, clientAddress, proxies);
    }

    private static class RequestAddressInfo {
        private final String requestAddress;
        private final String clientAddress;
        private final List<String> proxies;

        public RequestAddressInfo(String requestAddress, String clientAddress, List<String> proxies) {
            this.requestAddress = requestAddress;
            this.clientAddress = clientAddress;
            this.proxies = ImmutableList.copyOf(proxies);
        }

        public String getRequestAddress() {
            return this.requestAddress;
        }

        public String getClientAddress() {
            return this.clientAddress;
        }

        public List<String> getProxies() {
            return this.proxies;
        }
    }
}

