/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.validation;

import com.atlassian.crowd.manager.cache.NotInCacheException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.proxy.TrustedProxyManager;
import com.atlassian.crowd.manager.validation.ClientValidationException;
import com.atlassian.crowd.manager.validation.ClientValidationManager;
import com.atlassian.crowd.manager.validation.XForwardedForUtil;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.crowd.util.RemoteAddressCacheUtil;
import com.atlassian.crowd.util.RemoteAddressHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientValidationManagerImpl
implements ClientValidationManager {
    private static final Logger LOGGER = Logger.getLogger(ClientValidationManagerImpl.class);
    private final RemoteAddressCacheUtil cacheUtil;
    private final PropertyManager propertyManager;
    private final TrustedProxyManager trustedProxyManager;
    private final I18nHelper i18nHelper;

    public ClientValidationManagerImpl(RemoteAddressCacheUtil cacheUtil, PropertyManager propertyManager, TrustedProxyManager trustedProxyManager, I18nHelper i18nHelper) {
        this.cacheUtil = cacheUtil;
        this.propertyManager = propertyManager;
        this.trustedProxyManager = trustedProxyManager;
        this.i18nHelper = i18nHelper;
    }

    @Override
    public void validate(Application application, HttpServletRequest request) throws ClientValidationException {
        Validate.notNull((Object)application);
        Validate.notNull((Object)request);
        this.validateApplicationActive(application);
        this.validateRemoteAddress(application, request);
    }

    private void validateApplicationActive(Application application) throws ClientValidationException {
        if (!application.isActive()) {
            throw new ClientValidationException(this.i18nHelper.getText("application.inactive.error", application.getName()));
        }
    }

    private void validateRemoteAddress(Application application, HttpServletRequest request) throws ClientValidationException {
        boolean cacheEnabled;
        String clientAddress = XForwardedForUtil.getTrustedAddress(this.trustedProxyManager, request);
        String clientHost = request.getRemoteHost();
        ArrayList<RemoteAddress> clientAddresses = new ArrayList<RemoteAddress>();
        for (String address : Arrays.asList(clientAddress, clientHost)) {
            clientAddresses.add(new RemoteAddress(address));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Client address: " + clientAddress));
            LOGGER.debug((Object)("Client host: " + clientHost));
        }
        if ((cacheEnabled = this.propertyManager.isCacheEnabled()) && this.findValidAddressInCache(application, clientAddresses)) {
            return;
        }
        if (this.findValidAddress(application, application.getRemoteAddresses(), clientAddresses, cacheEnabled)) {
            return;
        }
        String errorMsg = this.i18nHelper.getText("client.forbidden.exception", Arrays.asList(clientAddress, clientHost, application.getName()));
        LOGGER.info((Object)errorMsg);
        throw new ClientValidationException(errorMsg);
    }

    private boolean findValidAddress(Application application, Collection<RemoteAddress> allowedAddresses, List<RemoteAddress> addresses, boolean cacheEnabled) {
        for (RemoteAddress address : addresses) {
            boolean addressValid = this.isAddressValid(allowedAddresses, address);
            if (cacheEnabled) {
                this.cacheUtil.setPermitted(application, address, addressValid);
            }
            if (!addressValid) continue;
            return true;
        }
        return false;
    }

    private boolean isAddressValid(Collection<RemoteAddress> allowedAddresses, RemoteAddress address) {
        for (RemoteAddress allowedAddress : allowedAddresses) {
            if (!RemoteAddressHelper.isAddressAllowed((RemoteAddress)allowedAddress, (RemoteAddress)address)) continue;
            return true;
        }
        return false;
    }

    private boolean findValidAddressInCache(Application application, List<RemoteAddress> addresses) {
        Iterator<RemoteAddress> it = addresses.iterator();
        while (it.hasNext()) {
            RemoteAddress address = it.next();
            try {
                if (this.cacheUtil.getPermitted(application, address)) {
                    return true;
                }
                it.remove();
            }
            catch (NotInCacheException e) {}
        }
        return false;
    }
}

