package com.atlassian.crowd.manager.validation;

import java.net.InetAddress;

import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.ip.IPMatcher;

/**
 * Validates a connection attempt based on whether the client address matches the set of allowed remote
 * addresses of the application.
 */
public class ApplicationRemoteAddressValidatorImpl implements ApplicationRemoteAddressValidator {
    @Override
    public boolean validate(Application application, InetAddress clientAddress) {
        final IPMatcher.Builder ipMatcherBuilder = IPMatcher.builder();
        for (RemoteAddress allowedAddress : application.getRemoteAddresses()) {
            ipMatcherBuilder.addPatternOrHost(allowedAddress.getAddress());
        }
        return ipMatcherBuilder.build().matches(clientAddress);
    }
}
