package com.atlassian.crowd.service.token;

import java.util.Date;

/**
 * Service for handling expirable user tokens
 *
 * @since v2.8
 */
public interface ExpirableUserTokenService {
    /**
     * Remove all tokens which have expired as of the given date
     *
     * @param expiryDate Effective expiry date to enforce
     * @return true if any tokens were deleted, false otherwise
     */
    boolean removeExpiredTokens(Date expiryDate);
}
